/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class GetCounterNamesOperation
extends BaseCounterOperation<Collection<String>> {
    private int size;
    private Collection<String> names;

    public GetCounterNamesOperation(Codec codec, ChannelFactory transportFactory, AtomicInteger topologyId, Configuration cfg) {
        super((short)100, (short)101, codec, transportFactory, topologyId, cfg, "", false);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendHeader(channel);
        this.setCacheName();
    }

    @Override
    protected void reset() {
        super.reset();
        this.names = null;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        assert (status == 0);
        if (this.names == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.names = new ArrayList<String>(this.size);
        }
        while (this.names.size() < this.size) {
            this.names.add(ByteBufUtil.readString(buf));
            decoder.checkpoint();
        }
        this.complete(this.names);
    }
}

