/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    SUBSYSTEM("subsystem"),
    MODIFY_WSDL_ADDRESS("modify-wsdl-address"),
    WSDL_HOST("wsdl-host"),
    WSDL_PORT("wsdl-port"),
    WSDL_SECURE_PORT("wsdl-secure-port"),
    WSDL_URI_SCHEME("wsdl-uri-scheme"),
    WSDL_PATH_REWRITE_RULE("wsdl-path-rewrite-rule"),
    CLIENT_CONFIG("client-config"),
    ENDPOINT_CONFIG("endpoint-config"),
    CONFIG_NAME("config-name"),
    PROPERTY("property"),
    PROPERTY_NAME("property-name"),
    PROPERTY_VALUE("property-value"),
    PRE_HANDLER_CHAIN("pre-handler-chain"),
    POST_HANDLER_CHAIN("post-handler-chain"),
    PRE_HANDLER_CHAINS("pre-handler-chains"),
    POST_HANDLER_CHAINS("post-handler-chains"),
    HANDLER_CHAIN("handler-chain"),
    PROTOCOL_BINDINGS("protocol-bindings"),
    HANDLER("handler"),
    HANDLER_NAME("handler-name"),
    HANDLER_CLASS("handler-class");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

