/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.jboss.logging.Logger;

public class JDBCDataSourceUtils {
    private static final Logger logger = Logger.getLogger(JDBCDataSourceUtils.class);

    public static DataSource getDataSource(String dataSourceClassName, Map<String, Object> dataSourceProperties) {
        logger.info((Object)new StringBuilder("Initialising JDBC data source: ").append(dataSourceClassName).append(" ").append(dataSourceProperties.keySet().stream().map(key -> key + "=" + dataSourceProperties.get(key)).collect(Collectors.joining(", ", "{", "}"))));
        try {
            DataSource dataSource = (DataSource)Class.forName(dataSourceClassName).newInstance();
            for (Map.Entry<String, Object> entry : dataSourceProperties.entrySet()) {
                PropertyUtils.setProperty((Object)dataSource, (String)entry.getKey(), (Object)entry.getValue());
            }
            return dataSource;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + dataSourceClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate DataSource", e);
        }
    }
}

