/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.NamespaceContextInterceptor;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DelegatingSupplier;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class NamespaceConfigurator
implements ComponentConfigurator {
    @Override
    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        final ComponentNamingMode namingMode = description.getNamingMode();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String compName = configuration.getComponentName();
        final ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication((String)applicationName);
        final ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)applicationName, (String)moduleName);
        final ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)applicationName, (String)moduleName, (String)compName);
        InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
        final DelegatingSupplier<NamingStore> appSupplier = selector.getAppContextSupplier();
        final DelegatingSupplier<NamingStore> moduleSupplier = selector.getModuleContextSupplier();
        final DelegatingSupplier<NamingStore> compSupplier = selector.getCompContextSupplier();
        final DelegatingSupplier<NamingStore> jbossSupplier = selector.getJbossContextSupplier();
        final DelegatingSupplier<NamingStore> globalSupplier = selector.getGlobalContextSupplier();
        final DelegatingSupplier<NamingStore> exportedSupplier = selector.getExportedContextSupplier();
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            @Override
            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) {
                appSupplier.set(serviceBuilder.requires(appContextServiceName));
                moduleSupplier.set(serviceBuilder.requires(moduleContextServiceName));
                if (namingMode == ComponentNamingMode.CREATE) {
                    compSupplier.set(serviceBuilder.requires(compContextServiceName));
                } else if (namingMode == ComponentNamingMode.USE_MODULE) {
                    compSupplier.set(serviceBuilder.requires(moduleContextServiceName));
                }
                globalSupplier.set(serviceBuilder.requires(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME));
                jbossSupplier.set(serviceBuilder.requires(ContextNames.JBOSS_CONTEXT_SERVICE_NAME));
                exportedSupplier.set(serviceBuilder.requires(ContextNames.EXPORTED_CONTEXT_SERVICE_NAME));
            }
        });
        ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)new NamespaceContextInterceptor(selector, context.getDeploymentUnit().getServiceName()));
        configuration.addPostConstructInterceptor((InterceptorFactory)interceptorFactory, 1536);
        configuration.addPreDestroyInterceptor((InterceptorFactory)interceptorFactory, 1024);
        if (description.isPassivationApplicable()) {
            configuration.addPrePassivateInterceptor((InterceptorFactory)interceptorFactory, 1024);
            configuration.addPostActivateInterceptor((InterceptorFactory)interceptorFactory, 1024);
        }
        configuration.setNamespaceContextInterceptorFactory((InterceptorFactory)interceptorFactory);
        configuration.setNamespaceContextSelector(selector);
    }
}

