/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.logging;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYEE", length=4)
public interface EeLogger
extends BasicLogger {
    public static final EeLogger ROOT_LOGGER = (EeLogger)Logger.getMessageLogger(EeLogger.class, (String)"org.jboss.as.ee");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not resolve %s %s")
    public void cannotResolve(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Failed to destroy component instance %s")
    public void componentDestroyFailure(@Cause Throwable var1, ComponentInstance var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Not installing optional component %s due to an exception (enable DEBUG log level to see the cause)")
    public void componentInstallationFailure(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="[Managed Bean spec, section %s] Managed bean implementation class MUST NOT be an interface - %s is an interface, hence won't be considered as a managed bean.")
    public void invalidManagedBeanAbstractOrFinal(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="[Managed Bean spec, section %s] Managed bean implementation class MUST NOT be abstract or final - %s won't be considered as a managed bean, since it doesn't meet that requirement.")
    public void invalidManagedBeanInterface(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Exception while invoking pre-destroy interceptor for component class: %s")
    public void preDestroyInterceptorFailure(@Cause Throwable var1, Class<?> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14, value="%s in subdeployment ignored. jboss-ejb-client.xml is only parsed for top level deployments.")
    public void subdeploymentIgnored(String var1);

    @Message(id=19, value="Could not find alternate deployment descriptor %s specified for %s")
    public DeploymentUnitProcessingException alternateDeploymentDescriptor(VirtualFile var1, VirtualFile var2);

    @Message(id=20, value="%s annotations must provide a %s.")
    public IllegalArgumentException annotationAttributeMissing(String var1, String var2);

    @Message(id=21, value="Cannot add any more items once getSortedItems() has been called")
    public IllegalStateException cannotAddMoreItems();

    @Message(id=22, value="%s may not be empty")
    public RuntimeException cannotBeEmpty(String var1);

    @Message(id=23, value="%s cannot be null or empty: %s")
    public IllegalArgumentException cannotBeNullOrEmpty(String var1, Object var2);

    @Message(id=24, value="Could not configure component %s")
    public DeploymentUnitProcessingException cannotConfigureComponent(@Cause Throwable var1, String var2);

    @Message(id=25, value="Could not determine type for resource-env-ref %s")
    public DeploymentUnitProcessingException cannotDetermineType(String var1);

    @Message(id=26, value="Could not determine type for %s %s please specify the %s.")
    public DeploymentUnitProcessingException cannotDetermineType(String var1, String var2, String var3);

    @Message(id=27, value="Could not load %s referenced in env-entry")
    public DeploymentUnitProcessingException cannotLoad(String var1);

    public DeploymentUnitProcessingException cannotLoad(@Cause Throwable var1, String var2);

    @Message(id=28, value="Could not load interceptor class %s")
    public RuntimeException cannotLoadInterceptor(@Cause Throwable var1, String var2);

    @Message(id=29, value="Could not load interceptor class %s on component %s")
    public DeploymentUnitProcessingException cannotLoadInterceptor(@Cause Throwable var1, String var2, Class<?> var3);

    @Message(id=30, value="Could not load view class %s for component %s")
    public DeploymentUnitProcessingException cannotLoadViewClass(@Cause Throwable var1, String var2, ComponentConfiguration var3);

    @Message(id=31, value="Unable to process modules in application.xml for EAR [%s], module file %s not found")
    public DeploymentUnitProcessingException cannotProcessEarModule(VirtualFile var1, String var2);

    @Message(id=32, value="Unable to parse resource-ref URI: %s")
    public DeploymentUnitProcessingException cannotParseResourceRefUri(@Cause Throwable var1, String var2);

    @Message(id=33, value="Could not resolve injection point %s on class %s specified in web.xml")
    public DeploymentUnitProcessingException cannotResolveInjectionPoint(String var1, String var2);

    @Message(id=34, value="Could not resolve method %s on class %s with annotations %s")
    public RuntimeException cannotResolveMethod(MethodIdentifier var1, Class<?> var2, Collection<?> var3);

    @Message(id=36, value="Cannot specify both a %s and a %s in an environment entry.")
    public DeploymentUnitProcessingException cannotSpecifyBoth(String var1, String var2);

    @Message(id=37, value="Circular dependency installing %s")
    public IllegalArgumentException circularDependency(String var1);

    @Message(id=38, value="%s annotation is only allowed on a class. %s is not a class.")
    public DeploymentUnitProcessingException classOnlyAnnotation(String var1, AnnotationTarget var2);

    @Message(id=40, value="A component named '%s' is already defined in this module")
    public IllegalArgumentException componentAlreadyDefined(String var1);

    @Message(id=41, value="Component class %s for component %s has errors: %n%s")
    public DeploymentUnitProcessingException componentClassHasErrors(String var1, String var2, String var3);

    @Message(id=42, value="Failed to construct component instance")
    public IllegalStateException componentConstructionFailure(@Cause Throwable var1);

    @Message(id=43, value="Component is stopped")
    public ComponentIsStoppedException componentIsStopped();

    @Message(id=44, value="Component not available (interrupted)")
    public IllegalStateException componentNotAvailable();

    @Message(id=45, value="No component found for type '%s'")
    public DeploymentUnitProcessingException componentNotFound(String var1);

    @Message(id=46, value="Failed to instantiate component view")
    public IllegalStateException componentViewConstructionFailure(@Cause Throwable var1);

    @Message(id=47, value="Incompatible conflicting binding at %s source: %s")
    public IllegalArgumentException conflictingBinding(String var1, InjectionSource var2);

    @Message(id=48, value="Could not find default constructor for %s")
    public DeploymentUnitProcessingException defaultConstructorNotFound(Class<?> var1);

    @Message(id=50, value="No default constructor for interceptor class %s on component %s")
    public DeploymentUnitProcessingException defaultConstructorNotFoundOnComponent(String var1, Class<?> var2);

    @Message(id=51, value="%s elements must provide a %s.")
    public IllegalArgumentException elementAttributeMissing(String var1, String var2);

    @Message(id=52, value="Failed to install component %s")
    public DeploymentUnitProcessingException failedToInstallComponent(@Cause Throwable var1, String var2);

    @Message(id=53, value="Failed to parse %s")
    public DeploymentUnitProcessingException failedToParse(@Cause Throwable var1, VirtualFile var2);

    @Message(id=54, value="Failed to process children for EAR [%s]")
    public DeploymentUnitProcessingException failedToProcessChild(@Cause Throwable var1, VirtualFile var2);

    @Message(id=55, value="Failed to read %s entries for application [%s]")
    public String failedToRead(String var1, String var2);

    @Message(id=56, value="Failed to read %s entries for module [%s, %s]")
    public String failedToRead(String var1, String var2, String var3);

    @Message(id=57, value="Failed to read %s entries for component [%s, %s, %s]")
    public String failedToRead(String var1, String var2, String var3, String var4);

    @Message(id=58, value="No matching field found for '%s'")
    public DeploymentUnitProcessingException fieldNotFound(String var1);

    @Message(id=59, value="No injection target found")
    public IllegalStateException injectionTargetNotFound();

    @Message(id=60, value="%s of type java.lang.Character is not exactly one character long %s")
    public DeploymentUnitProcessingException invalidCharacterLength(String var1, String var2);

    @Message(id=61, value="%s is not a valid descriptor")
    public RuntimeException invalidDescriptor(String var1);

    @Message(id=62, value="Injection target %s on class %s is not compatible with the type of injection: %s")
    public DeploymentUnitProcessingException invalidInjectionTarget(String var1, String var2, Class<?> var3);

    @Message(id=63, value="Invalid number of arguments for method %s annotated with %s on class %s")
    public String invalidNumberOfArguments(String var1, DotName var2, DotName var3);

    @Message(id=64, value="A return type of %s is required for method %s annotated with %s on class %s")
    public IllegalArgumentException invalidReturnType(String var1, String var2, DotName var3, DotName var4);

    @Message(id=65, value="Invalid signature for method %s annotated with %s on class %s, signature must be '%s'")
    public String invalidSignature(String var1, DotName var2, DotName var3, String var4);

    @Message(id=66, value="Invalid value: %s for '%s' element")
    public XMLStreamException invalidValue(String var1, String var2, @Param Location var3);

    @Message(id=67, value="Method does not exist %s")
    public IllegalStateException methodNotFound(Method var1);

    @Message(id=68, value="No matching method found for method %s (%s) on %s")
    public DeploymentUnitProcessingException methodNotFound(String var1, String var2, String var3);

    @Message(id=69, value="@%s is only valid on method targets.")
    public DeploymentUnitProcessingException methodOnlyAnnotation(DotName var1);

    @Message(id=70, value="Multiple components found for type '%s'")
    public DeploymentUnitProcessingException multipleComponentsFound(String var1);

    @Message(id=71, value="More than one matching method found for method '%s (%s) on %s")
    public DeploymentUnitProcessingException multipleMethodsFound(String var1, String var2, String var3);

    @Message(id=72, value="Multiple setter methods for %s on class %s found when applying <injection-target> for env-entry")
    public DeploymentUnitProcessingException multipleSetterMethodsFound(String var1, String var2);

    @Message(id=73, value="No component instance associated")
    public IllegalStateException noComponentInstance();

    @Message(id=74, value="Binding name must not be null: %s")
    public DeploymentUnitProcessingException nullBindingName(BindingConfiguration var1);

    @Message(id=75, value="Managed bean class name cannot be null or empty")
    public IllegalArgumentException nullOrEmptyManagedBeanClassName();

    @Message(id=76, value="Resource reference type cannot be null or empty")
    public IllegalArgumentException nullOrEmptyResourceReferenceType();

    @Message(id=77, value="Cannot register a null resource reference processor")
    public IllegalArgumentException nullResourceReference();

    @Message(id=78, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=79, value="Can't add %s, priority 0x%s is already taken by %s")
    public IllegalArgumentException priorityAlreadyExists(Object var1, String var2, Object var3);

    @Message(id=82, value="Service not started")
    public IllegalStateException serviceNotStarted();

    @Message(id=83, value="%s injection target is invalid.  Only setter methods are allowed: %s")
    public IllegalArgumentException setterMethodOnly(String var1, MethodInfo var2);

    @Message(id=84, value="Unknown AnnotationTarget type: %s")
    public RuntimeException unknownAnnotationTargetType(AnnotationTarget var1);

    @Message(id=85, value="Unknown %s type %s")
    public DeploymentUnitProcessingException unknownElementType(String var1, String var2);

    @Message(id=86, value="Could not find method %s %s on view %s of %s")
    public IllegalArgumentException viewMethodNotFound(String var1, String var2, Class<?> var3, Class<?> var4);

    @Message(id=88, value="Unexpected element '%s' encountered")
    public XMLStreamException unexpectedElement(QName var1, @Param Location var2);

    @Message(id=89, value="Failed to process jboss-ejb-client.xml")
    public DeploymentUnitProcessingException failedToProcessEJBClientDescriptor(@Cause Throwable var1);

    @Message(id=90, value="Exception while parsing jboss-ejb-client.xml file found at %s")
    public DeploymentUnitProcessingException xmlErrorParsingEJBClientDescriptor(@Cause XMLStreamException var1, String var2);

    @Message(id=91, value="%s")
    public XMLStreamException errorParsingEJBClientDescriptor(String var1, @Param Location var2);

    @Message(id=92, value="No message destination with name %s for binding %s")
    public String noMessageDestination(String var1, String var2);

    @Message(id=93, value="More than one message destination with name %s for binding %s destinations: %s")
    public String moreThanOneMessageDestination(String var1, String var2, Set<String> var3);

    @Message(id=94, value="Failed to load jboss.properties")
    public DeploymentUnitProcessingException failedToLoadJbossProperties(@Cause IOException var1);

    @Message(id=95, value="Unsupported ear module type: %s")
    public DeploymentUnitProcessingException unsupportedModuleType(String var1);

    @Message(id=96, value="library-directory of value / is not supported")
    public DeploymentUnitProcessingException rootAsLibraryDirectory();

    @Message(id=97, value="Module may not be a child of the EAR's library directory. Library directory: %s, module file name: %s")
    public DeploymentUnitProcessingException earModuleChildOfLibraryDirectory(String var1, String var2);

    @Message(id=98, value="ManagedReference was null and injection is not optional for injection into field %s")
    public RuntimeException managedReferenceWasNull(Field var1);

    @Message(id=100, value="Global modules may not specify 'annotations', 'meta-inf' or 'services'.")
    public String propertiesNotAllowedOnGlobalModules();

    @Message(id=102, value="EE Concurrent Service's value uninitialized.")
    public IllegalStateException concurrentServiceValueUninitialized();

    @Message(id=103, value="EE Concurrent ContextHandle serialization must be handled by the factory.")
    public IOException serializationMustBeHandledByTheFactory();

    @Message(id=104, value="The EE Concurrent Context %s already has a factory named %s")
    public IllegalArgumentException factoryAlreadyExists(ConcurrentContext var1, String var2);

    @Message(id=105, value="EE Concurrent Context %s does not has a factory named %s")
    public IOException factoryNotFound(ConcurrentContext var1, String var2);

    @Message(id=106, value="EE Concurrent Context %s service not installed.")
    public IOException concurrentContextServiceNotInstalled(ServiceName var1);

    @Message(id=107, value="EE Concurrent Transaction Setup Provider service not installed.")
    public IllegalStateException transactionSetupProviderServiceNotInstalled();

    @Message(id=108, value="Instance data can only be set during construction")
    public IllegalStateException instanceDataCanOnlyBeSetDuringConstruction();

    @Message(id=109, value="A class must not declare more than one AroundInvoke method. %s has %s methods annotated.")
    public DeploymentUnitProcessingException aroundInvokeAnnotationUsedTooManyTimes(DotName var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=110, value="Failed to run scheduled task")
    public void failedToRunTask(@Cause Exception var1);

    @Message(id=111, value="Cannot run scheduled task %s as container is suspended")
    public IllegalStateException cannotRunScheduledTask(Object var1);

    @Message(id=112, value="The core-threads value must be greater than 0 when the queue-length is %s")
    public OperationFailedException invalidCoreThreadsSize(String var1);

    @Message(id=113, value="The max-threads value %d cannot be less than the core-threads value %d.")
    public OperationFailedException invalidMaxThreads(int var1, int var2);

    @Message(id=114, value="Class does not implement all of the provided interfaces")
    public IllegalArgumentException classDoesNotImplementAllInterfaces();

    @Message(id=115, value="The name of the %s is null")
    public IllegalArgumentException nullName(String var1);

    @Message(id=116, value="%s is null in the %s %s")
    public IllegalArgumentException nullVar(String var1, String var2, String var3);

    @Message(id=117, value="Field %s cannot be set - object of %s loaded by %s is not assignable to %s loaded by %s")
    public IllegalArgumentException cannotSetField(String var1, Class<?> var2, ClassLoader var3, Class<?> var4, ClassLoader var5);

    @Message(id=120, value="Failed to locate executor service '%s'")
    public OperationFailedException executorServiceNotFound(ServiceName var1);

    @Message(id=121, value="Unsupported attribute '%s'")
    public IllegalStateException unsupportedExecutorServiceMetric(String var1);

    @Message(id=122, value="Directory path %s in %s global-directory resource does not point to a valid directory.")
    public StartException globalDirectoryDoNotExist(String var1, String var2);

    @Message(id=123, value="Global directory %s cannot be added, because global directory %s is already defined.")
    public OperationFailedException oneGlobalDirectory(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=124, value="Error deleting Jakarta Authorization Policy")
    public void errorDeletingJACCPolicy(@Cause Throwable var1);

    @Message(id=125, value="Unable to start the %s service")
    public StartException unableToStartException(String var1, @Cause Throwable var2);

    @Message(id=126, value="Rejected due to maximum number of requests")
    public RejectedExecutionException rejectedDueToMaxRequests();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=127, value="Invalid '%s' name segment for env, name can't start with '/' prefix, prefix has been removed")
    public void invalidNamePrefix(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=128, value="Failure when terminating %s hung task %s")
    public void huntTaskTerminationFailure(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=129, value="%s hung task %s cancelled")
    public void hungTaskCancelled(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=130, value="%s hung task %s not cancelled")
    public void hungTaskNotCancelled(String var1, String var2);

    @Message(id=131, value="The attribute %s is no longer supported.")
    public XMLStreamException attributeNoLongerSupported(String var1);
}

