/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.reflect;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.security.ServerPermission;

public final class DeploymentReflectionIndex {
    private final Map<Class<?>, ClassReflectionIndex> classes = new HashMap();

    DeploymentReflectionIndex() {
    }

    public static DeploymentReflectionIndex create() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ServerPermission.CREATE_DEPLOYMENT_REFLECTION_INDEX);
        }
        return new DeploymentReflectionIndex();
    }

    public synchronized ClassReflectionIndex getClassIndex(Class clazz) {
        try {
            ClassReflectionIndex index = this.classes.get(clazz);
            if (index == null) {
                SecurityManager sm = System.getSecurityManager();
                index = sm == null ? new ClassReflectionIndex(clazz, this) : AccessController.doPrivileged(() -> new ClassReflectionIndex(clazz, this));
                this.classes.put(clazz, index);
            }
            return index;
        }
        catch (Throwable e) {
            throw ServerLogger.ROOT_LOGGER.errorGettingReflectiveInformation(clazz, clazz.getClassLoader(), e);
        }
    }
}

