/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.jbossts.star.provider.HttpResponseException;
import org.jboss.jbossts.star.util.HttpConnectionCreator;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxStatusMediaType;
import org.jboss.jbossts.star.util.media.txstatusext.CoordinatorElement;
import org.jboss.jbossts.star.util.media.txstatusext.TransactionManagerElement;
import org.jboss.jbossts.star.util.media.txstatusext.TransactionStatisticsElement;
import org.jboss.logging.Logger;

public class TxSupport {
    protected static final Logger log = Logger.getLogger(TxSupport.class);
    public static final String TX_CONTEXT = System.getProperty("rest.tx.context.path", "/rest-tx");
    public static final String TX_PATH = "/tx/";
    public static final String TX_SEGMENT = "transaction-manager/";
    public static final int DEFAULT_READ_TIMEOUT = 20000;
    private static int PORT = 8080;
    private static String BIND_ADDRESS = System.getProperty("jboss.bind.address", "localhost");
    private static String BASE_URL = "http://" + BIND_ADDRESS + ':';
    private static final String DEF_TX_URL;
    public static String TXN_MGR_URL;
    public static final String URI_SEPARATOR = ",";
    private static Pattern NVP_PATTERN;
    private Map<String, String> links = new HashMap<String, String>();
    private String participantLinkHeader = null;
    private int status = -1;
    private String body = null;
    private String contentType = null;
    private String txnMgr;
    private int readTimeout = 20000;
    private static HttpConnectionCreator creator;

    public static void setTxnMgrUrl(String txnMgrUrl) {
        TXN_MGR_URL = txnMgrUrl;
    }

    public TxSupport(String txnMgr, int readTimeout) {
        this.txnMgr = txnMgr;
        this.readTimeout = readTimeout;
    }

    public TxSupport(String txnMgr) {
        this(txnMgr, 20000);
    }

    public TxSupport() {
        this(TXN_MGR_URL);
    }

    public TxSupport(int readTimeout) {
        this(TXN_MGR_URL, readTimeout);
    }

    public static void setHttpConnectionCreator(HttpConnectionCreator creator) {
        TxSupport.creator = creator;
    }

    public static void addLinkHeader(Response.ResponseBuilder response, UriInfo info, String title, String name, String ... pathComponents) {
        String basePath = (String)info.getMatchedURIs().get(0);
        UriBuilder builder = info.getBaseUriBuilder();
        builder.path(basePath);
        for (String component : pathComponents) {
            builder.path(component);
        }
        String uri = builder.build(new Object[0]).toString();
        TxSupport.setLinkHeader(response, title, name, uri, "text/plain");
    }

    public static void setLinkHeader(Response.ResponseBuilder builder, String title, String rel, String href, String type) {
        Link link = Link.fromUri((String)href).title(title).rel(rel).type(type).build(new Object[0]);
        TxSupport.setLinkHeader(builder, link);
    }

    public static void setLinkHeader(Response.ResponseBuilder builder, Link link) {
        builder.header("Link", (Object)link);
    }

    public Collection<String> getTransactions() throws HttpResponseException {
        return this.getTransactions("application/txlist");
    }

    public Collection<String> getTransactions(String mediaType) throws HttpResponseException {
        String content = this.httpRequest(new int[]{200}, this.txnMgr, "GET", mediaType, null, this.links);
        ArrayList<String> txns = new ArrayList<String>();
        if (content.length() == 0) {
            return txns;
        }
        for (String txn : content.split(URI_SEPARATOR)) {
            txns.add(txn.trim());
        }
        return txns;
    }

    public int txCount() throws HttpResponseException {
        String content = this.httpRequest(new int[]{200}, this.txnMgr, "GET", "application/txlist", null, null);
        return content.length() == 0 ? 0 : content.split(URI_SEPARATOR).length;
    }

    public TxSupport startTx() throws HttpResponseException {
        this.httpRequest(new int[]{201}, this.txnMgr, "POST", "application/x-www-form-urlencoded", "", this.links);
        this.links.put("transaction", this.links.get("location"));
        return this;
    }

    public TxSupport startTx(long milliseconds) throws HttpResponseException {
        this.httpRequest(new int[]{201}, this.txnMgr, "POST", "application/x-www-form-urlencoded", "timeout=" + milliseconds, this.links);
        this.links.put("transaction", this.links.get("location"));
        return this;
    }

    public String commitTx() throws HttpResponseException {
        return this.httpRequest(new int[]{200}, this.links.get("terminator"), "PUT", "application/txstatus", TxStatusMediaType.TX_COMMITTED, null);
    }

    public String rollbackTx() throws HttpResponseException {
        return this.httpRequest(new int[]{200}, this.links.get("terminator"), "PUT", "application/txstatus", TxStatusMediaType.TX_ROLLEDBACK, null);
    }

    public String markTxRollbackOnly() throws HttpResponseException {
        return this.httpRequest(new int[]{200}, this.links.get("terminator"), "PUT", "application/txstatus", TxStatusMediaType.TX_ROLLBACK_ONLY, null);
    }

    public String txStatus() throws HttpResponseException {
        return this.txStatus("application/txstatus", null);
    }

    public String txStatus(String mediaType) throws HttpResponseException {
        return this.txStatus(mediaType, this.links);
    }

    private String txStatus(String mediaType, Map<String, String> linkHeaders) throws HttpResponseException {
        return this.httpRequest(new int[]{200, 415}, this.links.get("transaction"), "GET", mediaType, null, linkHeaders);
    }

    public String getTxnUri() {
        return this.links.get("transaction");
    }

    public String getTerminatorURI() {
        return this.links.get("terminator");
    }

    public String getDurableParticipantEnlistmentURI() {
        return this.links.get("durable-participant");
    }

    public String getVolatileParticipantEnlistmentURI() {
        return this.links.get("volatile-participant");
    }

    public String getBody() {
        return this.body;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void refreshTransactionHeaders(Map<String, String> linkHeaders) throws HttpResponseException {
        this.httpRequest(new int[]{200}, this.links.get("transaction"), "HEAD", "application/txstatus", null, linkHeaders);
    }

    public String enlistTestResource(String pUrl, boolean vParticipant) throws HttpResponseException {
        String content = this.links.get("durable-participant");
        if (vParticipant) {
            content = content + URI_SEPARATOR + this.links.get("volatile-participant");
        }
        return this.httpRequest(new int[]{200}, pUrl, "POST", "application/x-www-form-urlencoded", content, null);
    }

    public static Map<String, String> decodeLinkHeader(String linkHeader) {
        int i;
        HashMap<String, String> decodedLinks = new HashMap<String, String>();
        if (linkHeader == null || (i = linkHeader.indexOf(60)) == -1) {
            return decodedLinks;
        }
        return TxSupport.extractLinkHeaders(linkHeader.substring(i), decodedLinks);
    }

    public StringBuilder addLink(StringBuilder linkHeader, String linkName, StringBuilder hrefPrefix, boolean first) {
        if (!first) {
            linkHeader.append(',');
        }
        linkHeader.append("<").append((CharSequence)hrefPrefix).append(linkName).append(">; rel=\"").append(linkName).append("\"");
        return linkHeader;
    }

    public StringBuilder addLink2(StringBuilder linkHeader, String linkName, String href, boolean first) {
        if (!first) {
            linkHeader.append(',');
        }
        linkHeader.append("<").append(href).append(">; rel=\"").append(linkName).append("\"");
        return linkHeader;
    }

    public String makeTwoPhaseAwareParticipantLinkHeader(String baseURI, boolean vParticipant, String uid1, String uid2) {
        StringBuilder resourcePrefix = new StringBuilder(baseURI);
        StringBuilder linkHeader = new StringBuilder();
        if (uid1 != null) {
            resourcePrefix.append('/').append(uid1);
        }
        if (uid2 != null) {
            resourcePrefix.append('/').append(uid2);
        }
        resourcePrefix.append('/');
        this.addLink(linkHeader, "participant", resourcePrefix, true);
        this.addLink(linkHeader, "terminator", resourcePrefix, false);
        if (vParticipant) {
            this.addLink(linkHeader, "volatile-participant", resourcePrefix, false);
        }
        this.participantLinkHeader = linkHeader.toString();
        return this.participantLinkHeader;
    }

    public String makeTwoPhaseAwareParticipantLinkHeader(String baseURI, String uid1, String uid2) {
        return this.makeTwoPhaseAwareParticipantLinkHeader(baseURI, false, uid1, uid2);
    }

    public String makeTwoPhaseAwareParticipantLinkHeader(String participantHref, String terminatorHref) {
        StringBuilder linkHeader = new StringBuilder();
        linkHeader.append("<").append(participantHref).append(">; rel=\"").append("participant").append("\"");
        linkHeader.append(',');
        linkHeader.append("<").append(terminatorHref).append(">; rel=\"").append("terminator").append("\"");
        this.participantLinkHeader = linkHeader.toString();
        return this.participantLinkHeader;
    }

    public String makeTwoPhaseUnAwareParticipantLinkHeader(String baseURI, boolean vParticipant, String uid1, String uid2, boolean commitOnePhase) {
        StringBuilder resourcePrefix = new StringBuilder(baseURI);
        StringBuilder linkHeader = new StringBuilder();
        if (uid1 != null) {
            resourcePrefix.append('/').append(uid1);
        }
        if (uid2 != null) {
            resourcePrefix.append('/').append(uid2);
        }
        resourcePrefix.append('/');
        this.addLink(linkHeader, "participant", resourcePrefix, true);
        this.addLink(linkHeader, "prepare", resourcePrefix, false);
        this.addLink(linkHeader, "commit", resourcePrefix, false);
        this.addLink(linkHeader, "rollback", resourcePrefix, false);
        if (commitOnePhase) {
            this.addLink(linkHeader, "commit-one-phase", resourcePrefix, false);
        }
        if (vParticipant) {
            this.addLink(linkHeader, "volatile-participant", resourcePrefix, false);
        }
        this.participantLinkHeader = linkHeader.toString();
        return this.participantLinkHeader;
    }

    public String makeTwoPhaseUnAwareParticipantLinkHeader(String participantHref, String prepareHref, String commitHref, String rollbackHref, String vParticipantHref) {
        StringBuilder linkHeader = new StringBuilder();
        linkHeader.append("<").append(participantHref).append(">; rel=\"").append("participant").append("\"");
        linkHeader.append(',');
        linkHeader.append("<").append(prepareHref).append(">; rel=\"").append("prepare").append("\"");
        linkHeader.append(',');
        linkHeader.append("<").append(commitHref).append(">; rel=\"").append("commit").append("\"");
        linkHeader.append(',');
        linkHeader.append("<").append(rollbackHref).append(">; rel=\"").append("rollback").append("\"");
        if (vParticipantHref != null) {
            linkHeader.append(',');
            linkHeader.append("<").append(vParticipantHref).append(">; rel=\"").append("volatile-participant").append("\"");
        }
        this.participantLinkHeader = linkHeader.toString();
        return this.participantLinkHeader;
    }

    public String makeTwoPhaseParticipantLinkHeader(HashMap<String, String> links) {
        if (!links.containsKey("participant")) {
            return null;
        }
        StringBuilder hdr = new StringBuilder();
        this.addLink2(hdr, "participant", links.get("participant"), true);
        if (links.containsKey("terminator")) {
            this.addLink2(hdr, "terminator", links.get("terminator"), false);
        }
        if (links.containsKey("commit")) {
            this.addLink2(hdr, "commit", links.get("commit"), false);
        }
        if (links.containsKey("prepare")) {
            this.addLink2(hdr, "prepare", links.get("prepare"), false);
        }
        if (links.containsKey("rollback")) {
            this.addLink2(hdr, "rollback", links.get("rollback"), false);
        }
        if (links.containsKey("commit-one-phase")) {
            this.addLink2(hdr, "commit-one-phase", links.get("commit-one-phase"), false);
        }
        this.participantLinkHeader = hdr.toString();
        return this.participantLinkHeader;
    }

    public String enlistParticipant(String participantLinkHeader) {
        return this.enlistParticipant(this.links.get("durable-participant"), participantLinkHeader);
    }

    public String enlistParticipant(String enlistUri, String participantLinkHeader) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("Link", participantLinkHeader);
        this.httpRequest(new int[]{201}, enlistUri, "POST", "application/x-www-form-urlencoded", null, this.links, reqHeaders);
        this.links.put("recovery", this.links.get("location"));
        return this.links.get("recovery");
    }

    public void enlistVolatileParticipant(String enlistUri, String participantLinkHeader) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("Link", participantLinkHeader);
        this.httpRequest(new int[]{200}, enlistUri, "PUT", null, null, this.links, reqHeaders);
    }

    public String httpRequest(int[] expect, String url, String method, String mediaType) throws HttpResponseException {
        return this.httpRequest(expect, url, method, mediaType, null, null, null);
    }

    public String httpRequest(int[] expect, String url, String method, String mediaType, String content) throws HttpResponseException {
        return this.httpRequest(expect, url, method, mediaType, content, null, null);
    }

    public String httpRequest(int[] expect, String url, String method, String mediaType, String content, Map<String, String> linkHeaders) throws HttpResponseException {
        return this.httpRequest(expect, url, method, mediaType, content, linkHeaders, null);
    }

    public String httpRequest(int[] expect, String url, String method, String mediaType, String content, Map<String, String> linkHeaders, Map<String, String> reqHeaders) throws HttpResponseException {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(null, url, method, mediaType, content, reqHeaders);
            connection.setReadTimeout(this.readTimeout);
            this.status = connection.getResponseCode();
            this.contentType = connection.getContentType();
            try {
                this.body = this.status != -1 ? this.getContent(connection) : "";
            }
            catch (IOException e) {
                RESTATLogger.atI18NLogger.info_txSupportHttpRequest(e.getMessage(), e);
                this.body = "";
            }
            if (linkHeaders != null) {
                this.extractLinkHeaders(connection, linkHeaders);
                this.addLocationHeader(connection, linkHeaders);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("httpRequest:\n\turl: " + url + "\n\tmethod: " + method + "\n\tmediaType: " + mediaType + "\n\tcontent: " + content + "\n\tresponse code: " + this.status + "\n\tresponse body: " + this.body));
            }
            if (expect != null && expect.length != 0) {
                for (int sc : expect) {
                    if (sc != this.status) continue;
                    String string = this.body;
                    return string;
                }
                throw new HttpResponseException(null, this.body, expect, this.status);
            }
            String e = this.body;
            return e;
        }
        catch (IOException e) {
            if (log.isTraceEnabled()) {
                log.tracef("httpRequest: io error: %s%n", (Object)e.getMessage());
            }
            throw new HttpResponseException((Throwable)e, "", expect, 503);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static Map<String, String> extractLinkHeaders(String header, Map<String, String> links) {
        if (header != null) {
            for (String linkHeader : header.split(URI_SEPARATOR)) {
                Link lnk = Link.valueOf((String)linkHeader);
                links.put(lnk.getRel(), lnk.getUri().toString());
            }
        }
        return links;
    }

    private void extractLinkHeaders(HttpURLConnection connection, Map<String, String> links) {
        Collection linkHeaders = connection.getHeaderFields().get("Link");
        if (linkHeaders == null) {
            linkHeaders = connection.getHeaderFields().get("link");
        }
        if (linkHeaders != null) {
            for (String header : linkHeaders) {
                TxSupport.extractLinkHeaders(header, links);
            }
        }
    }

    private void addLocationHeader(HttpURLConnection connection, Map<String, String> links) {
        try {
            if (connection.getResponseCode() == 201) {
                links.put("location", connection.getHeaderField("location"));
            }
        }
        catch (IOException e) {
            RESTATLogger.atI18NLogger.warn_txSupportAddLocationHeader(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection openConnection(HttpURLConnection connection, String url, String method, String contentType, String content, Map<String, String> reqHeaders) throws IOException {
        if (connection != null) {
            connection.disconnect();
        }
        connection = creator.open(new URL(url));
        connection.setRequestMethod(method);
        if (contentType != null) {
            if ("GET".equals(method)) {
                connection.setRequestProperty("Accept", contentType);
            } else {
                connection.setRequestProperty("Content-Type", contentType);
            }
        }
        if (reqHeaders != null) {
            for (Map.Entry<String, String> entry : reqHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (content != null) {
            connection.setDoOutput(true);
            try (OutputStream os = null;){
                os = connection.getOutputStream();
                os.write(content.getBytes());
                os.flush();
            }
        }
        return connection;
    }

    private String getContent(HttpURLConnection connection) throws IOException {
        return this.getContent(connection, new StringBuilder()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getContent(HttpURLConnection connection, StringBuilder builder) throws IOException {
        char[] buffer = new char[1024];
        try (BufferedReader reader = null;){
            int wasRead;
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            do {
                if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
                builder.append(buffer, 0, wasRead);
            } while (wasRead > -1);
        }
        return builder;
    }

    public static void matchNames(Map<String, String> pairs, String content, String splitChars) {
        if (content != null) {
            String[] lines = splitChars == null ? new String[]{content} : content.split(splitChars);
            for (String line : lines) {
                Matcher m = NVP_PATTERN.matcher(line);
                while (m.find()) {
                    String[] tokens;
                    for (String tok : tokens = m.group().trim().split("\\s+")) {
                        String[] pair = tok.split("=");
                        if (pair.length <= 1) continue;
                        pairs.put(pair[0], pair[1]);
                    }
                }
            }
        }
    }

    public static String getStringValue(String content, String name) {
        HashMap<String, String> matches = new HashMap<String, String>();
        TxSupport.matchNames(matches, content, null);
        return (String)matches.get(name);
    }

    public static int getIntValue(String content, String name, int defValue) {
        String v = TxSupport.getStringValue(content, name);
        if (v != null) {
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                RESTATLogger.atI18NLogger.warn_txSupportGetIntValue(e.getMessage(), e);
            }
        }
        return defValue;
    }

    public static UriBuilder getUriBuilder(UriInfo info, int npaths, String ... paths) {
        UriBuilder builder = info.getBaseUriBuilder();
        if (npaths > 0) {
            List segments = info.getPathSegments();
            for (int i = 0; i < npaths; ++i) {
                builder.path(((PathSegment)segments.get(i)).getPath());
            }
        } else {
            String basePath = (String)info.getMatchedURIs().get(0);
            builder.path(basePath);
        }
        for (String path : paths) {
            builder.path(path);
        }
        return builder;
    }

    public static URI getUri(UriInfo info, int npaths, String ... paths) {
        return TxSupport.getUriBuilder(info, npaths, paths).build(new Object[0]);
    }

    public static String extractUri(UriInfo info, String ... paths) {
        return TxSupport.getUri(info, info.getPathSegments().size(), paths).toASCIIString();
    }

    public static String buildURI(UriBuilder builder, String ... pathComponents) {
        for (String component : pathComponents) {
            builder.path(component);
        }
        return builder.build(new Object[0]).toString();
    }

    public static TxStatus toTxStatus(String statusContent) {
        String status = TxSupport.getStringValue(statusContent, "txstatus");
        return TxStatus.fromStatus(status);
    }

    public static String getStatus(String statusContent) {
        return TxSupport.getStringValue(statusContent, "txstatus");
    }

    public static String toContent(String property, String status) {
        return property + '=' + status;
    }

    public static String toStatusContent(String status) {
        return TxSupport.toContent("txstatus", status);
    }

    public String getLink(String linkName) {
        return this.links.get(linkName);
    }

    public TransactionStatisticsElement getTransactionStatistics() throws JAXBException {
        JAXBContext jc;
        Unmarshaller u;
        Object o;
        this.getTransactions();
        String statisticsHref = this.getLink("statistics");
        if (statisticsHref == null) {
            return null;
        }
        String txStats = this.httpRequest(new int[]{200}, statisticsHref, "GET", "application/txstatusext+xml");
        if (log.isTraceEnabled()) {
            log.tracef("Unmarshalling TransactionStatisticsElement\n%s", (Object)txStats);
        }
        if ((o = (u = (jc = JAXBContext.newInstance((String)TransactionStatisticsElement.class.getPackage().getName())).createUnmarshaller()).unmarshal((Source)new StreamSource(new StringReader(txStats)))) instanceof TransactionStatisticsElement) {
            return (TransactionStatisticsElement)o;
        }
        return (TransactionStatisticsElement)((JAXBElement)o).getValue();
    }

    public CoordinatorElement getTransactionInfo() throws JAXBException {
        if (!this.links.containsKey("transaction")) {
            throw new IllegalStateException("Not transaction has been started");
        }
        this.txStatus("application/txstatusext+xml");
        if (this.status == 415) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Unmarshalling CoordinatorElement\n%s", (Object)this.getBody());
        }
        JAXBContext jc = JAXBContext.newInstance((String)CoordinatorElement.class.getPackage().getName());
        Unmarshaller u = jc.createUnmarshaller();
        Object o = u.unmarshal((Source)new StreamSource(new StringReader(this.getBody())));
        return (CoordinatorElement)((JAXBElement)o).getValue();
    }

    public CoordinatorElement getTransactionInfo(String uri) throws JAXBException {
        this.links.put("transaction", uri);
        return this.getTransactionInfo();
    }

    public TransactionManagerElement getTransactionManagerInfo() throws JAXBException {
        JAXBContext jc;
        Unmarshaller u;
        Object o;
        String xml = this.httpRequest(new int[]{200, 415}, this.txnMgr, "GET", "application/txstatusext+xml");
        if (this.status == 415) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Unmarshalling TransactionManagerElement%n%s", (Object)xml);
        }
        if ((o = (u = (jc = JAXBContext.newInstance((String)TransactionManagerElement.class.getPackage().getName())).createUnmarshaller()).unmarshal((Source)new StreamSource(new StringReader(xml)))) instanceof TransactionManagerElement) {
            return (TransactionManagerElement)o;
        }
        return (TransactionManagerElement)((JAXBElement)o).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext getSSLContext() throws Exception {
        String trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePswd = System.getProperty("javax.net.ssl.trustStorePassword");
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream fis = new FileInputStream(trustStoreFile);){
            ks.load(fis, trustStorePswd.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, trustStorePswd.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), null, null);
        return sslContext;
    }

    static {
        TXN_MGR_URL = DEF_TX_URL = BASE_URL + PORT + TX_CONTEXT + TX_PATH + TX_SEGMENT;
        NVP_PATTERN = Pattern.compile("\\b\\w+\\s*=\\s*.*");
        creator = new HttpConnectionCreator(){

            @Override
            public HttpURLConnection open(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection();
            }
        };
    }
}

