/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

@Provider
@RequestScoped
public class OpenTelemetryContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String SERVER_SPAN = "otel_server_span";
    @Inject
    private OpenTelemetry openTelemetry;
    @Inject
    private Tracer tracer;

    public void filter(ContainerRequestContext requestContext) {
        if (this.tracer != null) {
            boolean remoteContext = requestContext.getHeaders().keySet().stream().anyMatch(k -> W3CTraceContextPropagator.getInstance().fields().contains(k));
            UriInfo uriInfo = requestContext.getUriInfo();
            URI requestUri = uriInfo.getRequestUri();
            String method = requestContext.getMethod();
            String uri = uriInfo.getPath();
            SpanBuilder spanBuilder = this.tracer.spanBuilder(method + " " + uri).setSpanKind(SpanKind.SERVER);
            if (remoteContext) {
                spanBuilder.setParent(this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)requestContext, (TextMapGetter)new TextMapGetter<ContainerRequestContext>(){

                    public String get(ContainerRequestContext requestContext, String key) {
                        if (requestContext.getHeaders().containsKey((Object)key)) {
                            return (String)((List)requestContext.getHeaders().get((Object)key)).get(0);
                        }
                        return null;
                    }

                    public Iterable<String> keys(ContainerRequestContext requestContext) {
                        return requestContext.getHeaders().keySet();
                    }
                }));
            } else {
                spanBuilder.setNoParent();
            }
            Span serverSpan = spanBuilder.startSpan();
            serverSpan.makeCurrent();
            serverSpan.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)method);
            serverSpan.setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)requestUri.getScheme());
            serverSpan.setAttribute(SemanticAttributes.HTTP_HOST, (Object)(requestUri.getHost() + ":" + requestUri.getPort()));
            serverSpan.setAttribute(SemanticAttributes.HTTP_TARGET, (Object)uri);
            requestContext.setProperty(SERVER_SPAN, (Object)serverSpan);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
        Object serverSpan = containerRequestContext.getProperty(SERVER_SPAN);
        if (serverSpan != null && serverSpan instanceof Span) {
            Span span = (Span)serverSpan;
            int status = containerResponseContext.getStatus();
            if (status >= 400) {
                span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, status);
            }
            span.end();
        }
    }
}

