/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.EJBException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.BMTInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EjbBMTInterceptor
extends BMTInterceptor {
    public static final InterceptorFactory FACTORY = new ComponentInstanceInterceptorFactory(){

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new EjbBMTInterceptor((EJBComponent)component);
        }
    };

    EjbBMTInterceptor(EJBComponent component) {
        super(component);
    }

    private void checkStatelessDone(EJBComponent component, InterceptorContext invocation, TransactionManager tm, Throwable ex) throws Exception {
        int status = 6;
        try {
            status = tm.getStatus();
        }
        catch (SystemException sex) {
            EjbLogger.ROOT_LOGGER.failedToGetStatus(sex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    tm.rollback();
                }
                catch (Exception sex) {
                    EjbLogger.ROOT_LOGGER.failedToRollback(sex);
                }
            }
            case 2: {
                String msg = EjbLogger.ROOT_LOGGER.transactionNotComplete(component.getComponentName());
                EjbLogger.ROOT_LOGGER.error(msg);
                if (ex instanceof Exception) {
                    throw new EJBException(msg, (Exception)ex);
                }
                throw new EJBException(msg, (Exception)new RuntimeException(ex));
            }
        }
        if (ex != null) {
            throw this.handleException(invocation, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object handleInvocation(InterceptorContext invocation) throws Exception {
        EJBComponent ejbComponent = this.getComponent();
        TransactionManager tm = ejbComponent.getTransactionManager();
        assert (tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        boolean exceptionThrown = false;
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable ex) {
            exceptionThrown = true;
            this.checkStatelessDone(ejbComponent, invocation, tm, ex);
            throw (Exception)ex;
        }
        finally {
            try {
                if (!exceptionThrown) {
                    this.checkStatelessDone(ejbComponent, invocation, tm, null);
                }
            }
            finally {
                tm.suspend();
            }
        }
    }
}

