/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriterContext;
import org.wildfly.clustering.marshalling.protostream.SizeComputingProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public class DefaultProtoStreamWriter
extends AbstractProtoStreamWriter {
    public DefaultProtoStreamWriter(ProtobufTagMarshaller.WriteContext context) {
        super(context);
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        ImmutableSerializationContext context = this.getSerializationContext();
        ProtoStreamMarshaller marshaller = this.findMarshaller(value.getClass());
        OptionalInt size = this.size(marshaller, value);
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(size);){
            TagWriterImpl writer = size.isPresent() ? TagWriterImpl.newInstance((ImmutableSerializationContext)context, (OutputStream)output, (int)size.getAsInt()) : TagWriterImpl.newInstance((ImmutableSerializationContext)context, (OutputStream)output);
            marshaller.writeTo(new DefaultProtoStreamWriter((ProtobufTagMarshaller.WriteContext)writer), value);
            writer.flush();
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            this.writeVarint32(length);
            this.writeRawBytes(buffer.array(), offset, length);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OptionalInt size(ProtoStreamMarshaller<Object> marshaller, Object value) {
        SizeComputingProtoStreamWriter writer = new SizeComputingProtoStreamWriter(this.getSerializationContext());
        try (ProtoStreamWriterContext context = (ProtoStreamWriterContext)ProtoStreamWriterContext.FACTORY.get().apply(writer);){
            marshaller.writeTo(writer, value);
            OptionalInt optionalInt = writer.get();
            return optionalInt;
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }
}

