/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger log = Logger.getLogger(AjaxExceptionHandlerImpl.class.getName());
    private Queue<ExceptionQueuedEvent> handled;
    private Queue<ExceptionQueuedEvent> unhandled;
    private ExceptionQueuedEvent handledAndThrown;

    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handledAndThrown;
    }

    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handled == null ? Collections.emptyList() : this.handled;
    }

    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        while (t != null) {
            Class<?> clazz = t.getClass();
            if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandled == null ? Collections.emptyList() : this.unhandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        if (this.unhandled != null && !this.unhandled.isEmpty()) {
            if (this.handled == null) {
                this.handled = new LinkedList<ExceptionQueuedEvent>();
            }
            ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
            FacesContext facesContext = null;
            do {
                ExceptionQueuedEvent event = this.unhandled.peek();
                try {
                    Throwable exception;
                    ExceptionQueuedEventContext context = event.getContext();
                    if (facesContext == null) {
                        facesContext = event.getContext().getContext();
                    }
                    if (!this.shouldSkip(exception = context.getException())) {
                        this.handledAndThrown = event;
                        Throwable rootCause = this.getRootCause(exception);
                        throwableList.add(rootCause == null ? exception : rootCause);
                        continue;
                    }
                    log.log(Level.SEVERE, exception.getClass().getName() + " occured while processing " + (context.inBeforePhase() ? "beforePhase() of " : (context.inAfterPhase() ? "afterPhase() of " : "")) + "phase " + context.getPhaseId() + ": " + "UIComponent-ClientId=" + (context.getComponent() != null ? context.getComponent().getClientId(context.getContext()) : "") + ", " + "Message=" + exception.getMessage());
                    log.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    this.handled.add(event);
                    this.unhandled.remove(event);
                }
            } while (!this.unhandled.isEmpty());
            if (!throwableList.isEmpty()) {
                PartialResponseWriter partialWriter = null;
                boolean responseComplete = false;
                if (facesContext == null) {
                    facesContext = FacesContext.getCurrentInstance();
                }
                facesContext = facesContext == null ? FacesContext.getCurrentInstance() : facesContext;
                ExternalContext externalContext = facesContext.getExternalContext();
                if (!facesContext.getExternalContext().isResponseCommitted()) {
                    facesContext.getExternalContext().responseReset();
                }
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                partialWriter = partialViewContext.getPartialResponseWriter();
                externalContext.setResponseContentType("text/xml");
                externalContext.setResponseCharacterEncoding("UTF-8");
                externalContext.addResponseHeader("Cache-control", "no-cache");
                try {
                    partialWriter.startDocument();
                    for (Throwable t : throwableList) {
                        this.renderAjaxError(partialWriter, t);
                    }
                    responseComplete = true;
                }
                catch (IOException e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot render exception on ajax request", e);
                    }
                }
                finally {
                    block26: {
                        if (responseComplete) {
                            try {
                                partialWriter.endDocument();
                                facesContext.responseComplete();
                            }
                            catch (IOException e1) {
                                if (!log.isLoggable(Level.SEVERE)) break block26;
                                log.log(Level.SEVERE, "Cannot render exception on ajax request", e1);
                            }
                        }
                    }
                }
            }
        }
    }

    private void renderAjaxError(PartialResponseWriter partialWriter, Throwable ex) throws IOException {
        partialWriter.startError(ex.getClass().getName());
        if (ex.getCause() != null) {
            partialWriter.write(ex.getCause().toString());
        } else if (ex.getMessage() != null) {
            partialWriter.write(ex.getMessage());
        }
        partialWriter.endError();
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        if (this.unhandled == null) {
            this.unhandled = new LinkedList<ExceptionQueuedEvent>();
        }
        this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
    }

    protected Throwable getRethrownException(Throwable exception) {
        Throwable toRethrow = this.getRootCause(exception);
        if (toRethrow == null) {
            toRethrow = exception;
        }
        return toRethrow;
    }

    protected FacesException wrap(Throwable exception) {
        if (exception instanceof FacesException) {
            return (FacesException)exception;
        }
        return new FacesException(exception);
    }

    protected boolean shouldSkip(Throwable exception) {
        return exception instanceof AbortProcessingException;
    }
}

