/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.Address;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalEntriesTask;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerListener;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;

public class InfinispanBeanManager<I, T, C>
implements BeanManager<I, T, TransactionBatch> {
    private final Cache<BeanKey<I>, BeanEntry<I>> cache;
    private final CacheProperties properties;
    private final BeanFactory<I, T> beanFactory;
    private final BeanGroupFactory<I, T, C> groupFactory;
    private final IdentifierFactory<I> identifierFactory;
    private final KeyAffinityService<BeanKey<I>> affinity;
    private final CommandDispatcherFactory dispatcherFactory;
    private final ExpirationConfiguration<T> expiration;
    private final PassivationConfiguration<T> passivation;
    private final Batcher<TransactionBatch> batcher;
    private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> filter;
    private final Group group;
    private final Function<BeanKey<I>, Node> primaryOwnerLocator;
    private volatile Scheduler<I, ImmutableBeanEntry<I>> scheduler;
    private volatile SchedulerListener listener;

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<I, T> configuration, IdentifierFactory<I> identifierFactory, Configuration<BeanKey<I>, BeanEntry<I>, BeanFactory<I, T>> beanConfiguration, Configuration<BeanGroupKey<I>, BeanGroupEntry<I, T, C>, BeanGroupFactory<I, T, C>> groupConfiguration) {
        this.filter = configuration.getBeanFilter();
        this.groupFactory = groupConfiguration.getFactory();
        this.beanFactory = beanConfiguration.getFactory();
        this.cache = beanConfiguration.getCache();
        this.properties = configuration.getProperties();
        this.batcher = new InfinispanBatcher(this.cache);
        Address address = this.cache.getCacheManager().getAddress();
        KeyAffinityServiceFactory affinityFactory = configuration.getAffinityFactory();
        KeyGenerator beanKeyGenerator = () -> ((BeanFactory)beanConfiguration.getFactory()).createKey(identifierFactory.createIdentifier());
        this.affinity = affinityFactory.createService(this.cache, beanKeyGenerator);
        this.identifierFactory = () -> ((BeanKey)this.affinity.getKeyForAddress(address)).getId();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpirationConfiguration();
        this.passivation = configuration.getPassivationConfiguration();
        this.primaryOwnerLocator = new PrimaryOwnerLocator(beanConfiguration.getCache(), configuration.getGroup());
        this.group = configuration.getGroup();
    }

    public void start() {
        this.affinity.start();
        Duration stopTimeout = Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
        Duration timeout = this.expiration.getTimeout();
        PrimaryOwnerScheduler localScheduler = timeout != null && !timeout.isNegative() ? new BeanExpirationScheduler(this.dispatcherFactory.getGroup(), this.batcher, this.beanFactory, this.expiration, new ExpiredBeanRemover<I, T>(this.beanFactory, this.expiration), stopTimeout) : null;
        String dispatcherName = String.join((CharSequence)"/", this.cache.getName(), this.filter.toString());
        this.scheduler = localScheduler != null ? (this.dispatcherFactory.getGroup().isSingleton() ? localScheduler : new PrimaryOwnerScheduler(this.dispatcherFactory, dispatcherName, (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler, this.primaryOwnerLocator, InfinispanBeanKey::new)) : null;
        ScheduleLocalEntriesTask scheduleTask = new ScheduleLocalEntriesTask(this.cache, this.filter, (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler);
        SchedulerTopologyChangeListener schedulerTopologyChangeListener = this.listener = localScheduler != null ? new SchedulerTopologyChangeListener(this.cache, (org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)localScheduler, (BiConsumer)scheduleTask) : null;
        if (this.listener != null) {
            scheduleTask.accept(new SimpleLocality(false), new CacheLocality(this.cache));
        }
    }

    public void stop() {
        if (this.listener != null) {
            this.listener.close();
        }
        if (this.scheduler != null) {
            this.scheduler.close();
        }
        this.affinity.stop();
        this.groupFactory.close();
    }

    public boolean isRemotable(Throwable throwable) {
        for (Throwable subject = throwable; subject != null; subject = subject.getCause()) {
            if (!(subject instanceof CacheException)) continue;
            return false;
        }
        return true;
    }

    public Affinity getStrictAffinity() {
        return this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(this.group.getName()) : new NodeAffinity(this.group.getLocalMember().getName());
    }

    public Affinity getWeakAffinity(I id) {
        org.infinispan.configuration.cache.Configuration config = this.cache.getCacheConfiguration();
        CacheMode mode = config.clustering().cacheMode();
        if (mode.isClustered()) {
            Node member = this.primaryOwnerLocator.apply(new InfinispanBeanKey<I>(id));
            return new NodeAffinity(member.getName());
        }
        return Affinity.NONE;
    }

    public Bean<I, T> createBean(I id, I groupId, T bean) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        BeanGroupEntry groupEntry = id == groupId ? (BeanGroupEntry)this.groupFactory.createValue(groupId, null) : (BeanGroupEntry)this.groupFactory.findValue(groupId);
        BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        group.addBean(id, bean);
        group.releaseBean(id, this.properties.isPersistent() ? this.passivation.getPassivationListener() : null);
        BeanEntry entry = (BeanEntry)this.beanFactory.createValue(id, groupId);
        return new SchedulableBean<I, T>(this.beanFactory.createBean(id, entry), entry, this.scheduler);
    }

    public Bean<I, T> findBean(I id) {
        Bean<I, T> bean;
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
        Bean<I, T> bean2 = bean = entry != null ? this.beanFactory.createBean(id, entry) : null;
        if (bean == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        if (bean.isExpired()) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Bean %s was found, but has expired", id);
            this.beanFactory.remove(id, this.expiration.getRemoveListener());
            return null;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel(id);
        }
        return new SchedulableBean<I, T>(bean, entry, this.scheduler);
    }

    public boolean containsBean(I id) {
        return this.cache.containsKey(this.beanFactory.createKey(id));
    }

    public IdentifierFactory<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        try (CacheStream entries = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).entrySet().stream();){
            int n = (int)entries.filter(this.filter).count();
            return n;
        }
    }

    public int getPassiveCount() {
        return this.groupFactory.getPassiveCount();
    }

    private static class SchedulableBean<I, T>
    implements Bean<I, T> {
        private final Bean<I, T> bean;
        private final ImmutableBeanEntry<I> entry;
        private Scheduler<I, ImmutableBeanEntry<I>> scheduler;

        SchedulableBean(Bean<I, T> bean, ImmutableBeanEntry<I> entry, Scheduler<I, ImmutableBeanEntry<I>> scheduler) {
            this.bean = bean;
            this.entry = entry;
            this.scheduler = scheduler;
        }

        public I getId() {
            return (I)this.bean.getId();
        }

        public I getGroupId() {
            return (I)this.bean.getGroupId();
        }

        public void remove(RemoveListener<T> listener) {
            this.bean.remove(listener);
        }

        public boolean isExpired() {
            return this.bean.isExpired();
        }

        public boolean isValid() {
            return this.bean.isValid();
        }

        public T acquire() {
            return (T)this.bean.acquire();
        }

        public boolean release() {
            return this.bean.release();
        }

        public void close() {
            this.bean.close();
            if (this.scheduler != null && this.bean.isValid()) {
                this.scheduler.schedule(this.bean.getId(), this.entry);
            }
        }
    }
}

