/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd;

import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.security.manager.WildFlySecurityManager;

@CommandDefinition(name="version", description="")
public class VersionCommand
implements Command<CLICommandInvocation> {
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        StringBuilder buf = new StringBuilder();
        buf.append("JBoss Admin Command-line Interface\n");
        buf.append("JBOSS_HOME: ").append(WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null)).append('\n');
        buf.append("Release: ");
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            buf.append("<connect to the controller and re-run the version command to see the release info>\n");
        } else {
            ModelNode req = new ModelNode();
            req.get("operation").set("read-resource");
            req.get("address").setEmptyList();
            try {
                ModelNode response = client.execute(req);
                if (Util.isSuccess(response)) {
                    if (response.hasDefined("result")) {
                        String codename;
                        ModelNode result = response.get("result");
                        int flag = 0;
                        if (result.hasDefined("release-version")) {
                            buf.append(result.get("release-version").asString());
                            flag = (byte)(flag + 1);
                        }
                        if (result.hasDefined("release-codename") && (codename = result.get("release-codename").asString()).length() > 0) {
                            buf.append(" \"").append(codename).append('\"');
                            flag = (byte)(flag + 1);
                        }
                        if (flag == 0) {
                            buf.append("release info was not provided by the controller");
                        }
                        if (result.hasDefined("product-name")) {
                            buf.append("\nProduct: ").append(result.get("product-name").asString());
                            if (result.hasDefined("product-version")) {
                                buf.append(' ').append(result.get("product-version").asString());
                            }
                        }
                    } else {
                        buf.append("result was not available.");
                    }
                } else {
                    buf.append(Util.getFailureDescription(response));
                }
                buf.append('\n');
            }
            catch (IOException e) {
                throw new CommandException("Failed to get the AS release info: " + e.getLocalizedMessage());
            }
        }
        buf.append("JAVA_HOME: ").append(WildFlySecurityManager.getEnvPropertyPrivileged((String)"JAVA_HOME", null)).append('\n');
        buf.append("java.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.version", null)).append('\n');
        buf.append("java.vm.vendor: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.vm.vendor", null)).append('\n');
        buf.append("java.vm.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"java.vm.version", null)).append('\n');
        buf.append("os.name: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"os.name", null)).append('\n');
        buf.append("os.version: ").append(WildFlySecurityManager.getPropertyPrivileged((String)"os.version", null));
        ctx.printLine(buf.toString());
        return CommandResult.SUCCESS;
    }
}

