/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import java.util.HashSet;
import java.util.Map;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.as.txn.service.UserTransactionAccessControlService;
import org.jboss.as.txn.service.UserTransactionBindingService;
import org.jboss.as.txn.service.UserTransactionService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class TransactionJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
        this.bindServices(deploymentUnit, serviceTarget, moduleContextServiceName);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
                if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
                ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
                this.bindServices(deploymentUnit, serviceTarget, compContextServiceName);
            }
        }
    }

    private void bindServices(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName contextServiceName) {
        ServiceName userTransactionServiceName = contextServiceName.append(new String[]{"UserTransaction"});
        UserTransactionBindingService userTransactionBindingService = new UserTransactionBindingService("UserTransaction");
        serviceTarget.addService(userTransactionServiceName, (Service)userTransactionBindingService).addDependency(UserTransactionAccessControlService.SERVICE_NAME, UserTransactionAccessControlService.class, userTransactionBindingService.getUserTransactionAccessControlServiceInjector()).addDependency(UserTransactionService.INTERNAL_SERVICE_NAME, UserTransaction.class, (Injector)new ManagedReferenceInjector((Injector)userTransactionBindingService.getManagedObjectInjector())).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)userTransactionBindingService.getNamingStoreInjector()).install();
        Map jndiComponentDependencies = (Map)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPONENT_JNDI_DEPENDENCIES);
        HashSet<ServiceName> jndiDependencies = (HashSet<ServiceName>)jndiComponentDependencies.get(contextServiceName);
        if (jndiDependencies == null) {
            jndiDependencies = new HashSet<ServiceName>();
            jndiComponentDependencies.put(contextServiceName, jndiDependencies);
        }
        jndiDependencies.add(userTransactionServiceName);
        ServiceName transactionSynchronizationRegistryName = contextServiceName.append(new String[]{"TransactionSynchronizationRegistry"});
        BinderService transactionSyncBinderService = new BinderService("TransactionSynchronizationRegistry");
        serviceTarget.addService(transactionSynchronizationRegistryName, (Service)transactionSyncBinderService).addDependency(TransactionSynchronizationRegistryService.INTERNAL_SERVICE_NAME, TransactionSynchronizationRegistry.class, (Injector)new ManagedReferenceInjector((Injector)transactionSyncBinderService.getManagedObjectInjector())).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)transactionSyncBinderService.getNamingStoreInjector()).install();
        jndiDependencies.add(transactionSynchronizationRegistryName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

