/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.connector.deployers.ds.processors.DsXmlDeploymentParsingProcessor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.ds.DsSecurity;
import org.jboss.as.connector.services.datasources.statistics.DataSourceStatisticsService;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.CommonDeploymentService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.connector.subsystems.datasources.XMLDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XMLXaDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.SecurityMetadata;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class DsXmlDeploymentInstallProcessor
implements DeploymentUnitProcessor {
    private static final String DATA_SOURCE = "data-source";
    private static final String XA_DATA_SOURCE = "xa-data-source";
    private static final String CONNECTION_PROPERTIES = "connection-properties";
    private static final String XA_CONNECTION_PROPERTIES = "xa-datasource-properties";
    private static final PathAddress SUBSYSTEM_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
    private static final PathAddress DATASOURCE_ADDRESS;
    private static final PathAddress XA_DATASOURCE_ADDRESS;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        List dataSourcesList = deploymentUnit.getAttachmentList(DsXmlDeploymentParsingProcessor.DATA_SOURCES_ATTACHMENT_KEY);
        boolean legacySecurityPresent = support.hasCapability("org.wildfly.legacy-security");
        for (DataSources dataSources : dataSourcesList) {
            PathAddress addr;
            String dsName;
            String jndiName;
            int i;
            if (dataSources.getDrivers() != null && !dataSources.getDrivers().isEmpty()) {
                ConnectorLogger.DS_DEPLOYER_LOGGER.driversElementNotSupported(deploymentUnit.getName());
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            if (dataSources.getDataSource() != null && !dataSources.getDataSource().isEmpty()) {
                for (i = 0; i < dataSources.getDataSource().size(); ++i) {
                    DataSource ds = (DataSource)dataSources.getDataSource().get(i);
                    if (ds.isEnabled().booleanValue() && ds.getDriver() != null) {
                        try {
                            jndiName = Util.cleanJndiName(ds.getJndiName(), ds.isUseJavaContext());
                            LocalDataSourceService lds = new LocalDataSourceService(jndiName, ContextNames.bindInfoFor((String)jndiName));
                            lds.getDataSourceConfigInjector().inject((Object)this.buildDataSource(ds));
                            dsName = ds.getJndiName();
                            addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(dsName, deploymentUnit, false);
                            this.installManagementModel(ds, deploymentUnit, addr);
                            boolean useLegacySecurity = legacySecurityPresent && DsXmlDeploymentInstallProcessor.isLegacySecurityRequired((SecurityMetadata)ds.getSecurity());
                            this.startDataSource(lds, jndiName, ds.getDriver(), serviceTarget, this.getRegistration(false, deploymentUnit), this.getResource(dsName, false, deploymentUnit), dsName, useLegacySecurity, ds.isJTA(), support);
                            continue;
                        }
                        catch (DeploymentUnitProcessingException dupe) {
                            throw dupe;
                        }
                        catch (Exception e) {
                            throw ConnectorLogger.ROOT_LOGGER.exceptionDeployingDatasource(e, ds.getJndiName());
                        }
                    }
                    ConnectorLogger.DS_DEPLOYER_LOGGER.debugf("Ignoring: %s", ds.getJndiName());
                }
            }
            if (dataSources.getXaDataSource() == null || dataSources.getXaDataSource().isEmpty()) continue;
            for (i = 0; i < dataSources.getXaDataSource().size(); ++i) {
                XaDataSource xads = (XaDataSource)dataSources.getXaDataSource().get(i);
                if (xads.isEnabled().booleanValue() && xads.getDriver() != null) {
                    try {
                        jndiName = Util.cleanJndiName(xads.getJndiName(), xads.isUseJavaContext());
                        XaDataSourceService xds = new XaDataSourceService(jndiName, ContextNames.bindInfoFor((String)jndiName));
                        xds.getDataSourceConfigInjector().inject((Object)this.buildXaDataSource(xads));
                        dsName = xads.getJndiName();
                        addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(dsName, deploymentUnit, true);
                        this.installManagementModel(xads, deploymentUnit, addr);
                        Credential credential = xads.getRecovery() == null ? null : xads.getRecovery().getCredential();
                        boolean useLegacySecurity = legacySecurityPresent && (DsXmlDeploymentInstallProcessor.isLegacySecurityRequired((SecurityMetadata)xads.getSecurity()) || DsXmlDeploymentInstallProcessor.isLegacySecurityRequired((SecurityMetadata)credential));
                        this.startDataSource(xds, jndiName, xads.getDriver(), serviceTarget, this.getRegistration(true, deploymentUnit), this.getResource(dsName, true, deploymentUnit), dsName, useLegacySecurity, true, support);
                        continue;
                    }
                    catch (Exception e) {
                        throw ConnectorLogger.ROOT_LOGGER.exceptionDeployingDatasource(e, xads.getJndiName());
                    }
                }
                ConnectorLogger.DS_DEPLOYER_LOGGER.debugf("Ignoring %s", xads.getJndiName());
            }
        }
    }

    private void installManagementModel(DataSource ds, DeploymentUnit deploymentUnit, PathAddress addr) {
        XMLDataSourceRuntimeHandler.INSTANCE.registerDataSource(addr, ds);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        deploymentResourceSupport.getDeploymentSubModel("datasources", addr.getLastElement());
        if (ds.getConnectionProperties() != null) {
            for (Map.Entry prop : ds.getConnectionProperties().entrySet()) {
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{addr.getLastElement(), PathElement.pathElement((String)CONNECTION_PROPERTIES, (String)((String)prop.getKey()))});
                deploymentResourceSupport.getDeploymentSubModel("datasources", registration);
            }
        }
    }

    private void installManagementModel(XaDataSource ds, DeploymentUnit deploymentUnit, PathAddress addr) {
        XMLXaDataSourceRuntimeHandler.INSTANCE.registerDataSource(addr, ds);
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        deploymentResourceSupport.getDeploymentSubModel("datasources", addr.getLastElement());
        if (ds.getXaDataSourceProperty() != null) {
            for (Map.Entry prop : ds.getXaDataSourceProperty().entrySet()) {
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{addr.getLastElement(), PathElement.pathElement((String)XA_CONNECTION_PROPERTIES, (String)((String)prop.getKey()))});
                deploymentResourceSupport.getDeploymentSubModel("datasources", registration);
            }
        }
    }

    private void undeployDataSource(DataSource ds, DeploymentUnit deploymentUnit) {
        PathAddress addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(ds.getJndiName(), deploymentUnit, false);
        XMLDataSourceRuntimeHandler.INSTANCE.unregisterDataSource(addr);
    }

    private void undeployXaDataSource(XaDataSource ds, DeploymentUnit deploymentUnit) {
        PathAddress addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(ds.getJndiName(), deploymentUnit, true);
        XMLXaDataSourceRuntimeHandler.INSTANCE.unregisterDataSource(addr);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        List dataSourcesList = deploymentUnit.getAttachmentList(DsXmlDeploymentParsingProcessor.DATA_SOURCES_ATTACHMENT_KEY);
        for (DataSources dataSources : dataSourcesList) {
            int i;
            if (dataSources.getDataSource() != null) {
                for (i = 0; i < dataSources.getDataSource().size(); ++i) {
                    DataSource ds = (DataSource)dataSources.getDataSource().get(i);
                    this.undeployDataSource(ds, deploymentUnit);
                }
            }
            if (dataSources.getXaDataSource() == null) continue;
            for (i = 0; i < dataSources.getXaDataSource().size(); ++i) {
                XaDataSource xads = (XaDataSource)dataSources.getXaDataSource().get(i);
                this.undeployXaDataSource(xads, deploymentUnit);
            }
        }
        deploymentUnit.removeAttachment(DsXmlDeploymentParsingProcessor.DATA_SOURCES_ATTACHMENT_KEY);
    }

    private ModifiableDataSource buildDataSource(DataSource ds) throws ValidateException {
        assert (ds.getSecurity() == null || ds.getSecurity() instanceof DsSecurity);
        return new ModifiableDataSource(ds.getConnectionUrl(), ds.getDriverClass(), ds.getDataSourceClass(), ds.getDriver(), ds.getTransactionIsolation(), ds.getConnectionProperties(), ds.getTimeOut(), (DsSecurity)ds.getSecurity(), ds.getStatement(), ds.getValidation(), ds.getUrlDelimiter(), ds.getUrlSelectorStrategyClassName(), ds.getNewConnectionSql(), ds.isUseJavaContext(), ds.getPoolName(), ds.isEnabled(), ds.getJndiName(), ds.isSpy(), ds.isUseCcm(), ds.isJTA(), ds.isConnectable(), ds.isTracking(), ds.getMcp(), ds.isEnlistmentTrace(), ds.getPool());
    }

    private ModifiableXaDataSource buildXaDataSource(XaDataSource xads) throws ValidateException {
        DsXaPoolImpl xaPool;
        if (xads.getXaPool() == null) {
            xaPool = new DsXaPoolImpl(Defaults.MIN_POOL_SIZE, Defaults.INITIAL_POOL_SIZE, Defaults.MAX_POOL_SIZE, Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL, Defaults.ALLOW_MULTIPLE_USERS, null, Defaults.FAIR, null);
        } else {
            DsXaPool p = xads.getXaPool();
            xaPool = new DsXaPoolImpl(this.getDef(p.getMinPoolSize(), Defaults.MIN_POOL_SIZE), this.getDef(p.getInitialPoolSize(), Defaults.INITIAL_POOL_SIZE), this.getDef(p.getMaxPoolSize(), Defaults.MAX_POOL_SIZE), this.getDef(p.isPrefill(), Defaults.PREFILL), this.getDef(p.isUseStrictMin(), Defaults.USE_STRICT_MIN), this.getDef(p.getFlushStrategy(), Defaults.FLUSH_STRATEGY), this.getDef(p.isSameRmOverride(), Defaults.IS_SAME_RM_OVERRIDE), this.getDef(p.isInterleaving(), Defaults.INTERLEAVING), this.getDef(p.isPadXid(), Defaults.PAD_XID), this.getDef(p.isWrapXaResource(), Defaults.WRAP_XA_RESOURCE), this.getDef(p.isNoTxSeparatePool(), Defaults.NO_TX_SEPARATE_POOL), this.getDef(p.isAllowMultipleUsers(), Defaults.ALLOW_MULTIPLE_USERS), p.getCapacity(), this.getDef(p.isFair(), Defaults.FAIR), p.getConnectionListener());
        }
        return new ModifiableXaDataSource(xads.getTransactionIsolation(), xads.getTimeOut(), xads.getSecurity(), xads.getStatement(), xads.getValidation(), xads.getUrlDelimiter(), xads.getUrlProperty(), xads.getUrlSelectorStrategyClassName(), xads.isUseJavaContext(), xads.getPoolName(), xads.isEnabled(), xads.getJndiName(), xads.isSpy(), xads.isUseCcm(), xads.isConnectable(), xads.isTracking(), xads.getMcp(), xads.isEnlistmentTrace(), xads.getXaDataSourceProperty(), xads.getXaDataSourceClass(), xads.getDriver(), xads.getNewConnectionSql(), (DsXaPool)xaPool, xads.getRecovery());
    }

    private <T> T getDef(T value, T def) {
        return value != null ? value : def;
    }

    private void startDataSource(AbstractDataSourceService dataSourceService, final String jndiName, String driverName, ServiceTarget serviceTarget, ManagementResourceRegistration registration, Resource resource, String managementName, boolean requireLegacySecurity, final boolean isTransactional, CapabilityServiceSupport support) throws DeploymentUnitProcessingException {
        ServiceName driverServiceName;
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        ServiceName dataSourceServiceName = AbstractDataSourceService.getServiceName(bindInfo);
        ServiceBuilder dataSourceServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService), dataSourceService.getExecutorServiceInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, dataSourceService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, dataSourceService.getRaRepositoryInjector()).addDependency(support.getCapabilityServiceName("org.wildfly.jca.transaction-integration"), TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector());
        dataSourceServiceBuilder.requires(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
        dataSourceServiceBuilder.requires(support.getCapabilityServiceName("org.wildfly.naming"));
        if (requireLegacySecurity) {
            if (support.hasCapability("org.wildfly.legacy-security")) {
                dataSourceServiceBuilder.addDependency(support.getCapabilityServiceName("org.wildfly.legacy-security.server-security-manager"), ServerSecurityManager.class, dataSourceService.getServerSecurityManager());
                dataSourceServiceBuilder.addDependency(support.getCapabilityServiceName("org.wildfly.legacy-security.subject-factory"), SubjectFactory.class, dataSourceService.getSubjectFactoryInjector());
            } else {
                throw ConnectorLogger.DS_DEPLOYER_LOGGER.legacySecurityNotAvailableForDsXml(managementName);
            }
        }
        if (registration.isAllowsOverride()) {
            ManagementResourceRegistration overrideRegistration = registration.getOverrideModel(managementName);
            if (overrideRegistration == null || overrideRegistration.isAllowsOverride()) {
                overrideRegistration = registration.registerOverrideModel(managementName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC);
            }
            DataSourceStatisticsService statsService = new DataSourceStatisticsService(registration, false);
            ServiceBuilder statsServiceSB = serviceTarget.addService(dataSourceServiceName.append(new String[]{"statistics"}), (Service)statsService);
            statsServiceSB.requires(dataSourceServiceName);
            statsServiceSB.addDependency(CommonDeploymentService.getServiceName(bindInfo), CommonDeployment.class, statsService.getCommonDeploymentInjector());
            statsServiceSB.setInitialMode(ServiceController.Mode.PASSIVE);
            statsServiceSB.install();
            DataSourceStatisticsService.registerStatisticsResources(resource);
        }
        if ((driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")})) != null) {
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, javax.sql.DataSource.class, referenceFactoryService.getDataSourceInjector());
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        if (isTransactional) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        } else {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundNonJTADataSource(jndiName);
                        }
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        if (isTransactional) {
                            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                            break;
                        }
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unBoundNonJTADataSource(jndiName);
                        break;
                    }
                    case REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static PathAddress getDataSourceAddress(String jndiName, DeploymentUnit deploymentUnit, boolean xa) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        if (deploymentUnit.getParent() == null) {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getName()));
        } else {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getParent().getName()));
            elements.add(PathElement.pathElement((String)"subdeployment", (String)deploymentUnit.getName()));
        }
        elements.add(PathElement.pathElement((String)"subsystem", (String)"datasources"));
        if (xa) {
            elements.add(PathElement.pathElement((String)XA_DATA_SOURCE, (String)jndiName));
        } else {
            elements.add(PathElement.pathElement((String)DATA_SOURCE, (String)jndiName));
        }
        return PathAddress.pathAddress(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource getOrCreate(Resource parent, PathAddress address) {
        Resource current = parent;
        for (PathElement element : address) {
            Resource resource = current;
            synchronized (resource) {
                if (current.hasChild(element)) {
                    current = current.requireChild(element);
                } else {
                    Resource resource2 = Resource.Factory.create();
                    current.registerChild(element, resource2);
                    current = resource2;
                }
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(String dsName, boolean xa, DeploymentUnit unit) {
        Resource root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        String key = xa ? XA_DATA_SOURCE : DATA_SOURCE;
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)key, (String)dsName)});
        Resource resource = root;
        synchronized (resource) {
            Resource subsystem = DsXmlDeploymentInstallProcessor.getOrCreate(root, SUBSYSTEM_ADDRESS);
            return DsXmlDeploymentInstallProcessor.getOrCreate(subsystem, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagementResourceRegistration getRegistration(boolean xa, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ManagementResourceRegistration registration = (ManagementResourceRegistration)unit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
            PathAddress address = xa ? XA_DATASOURCE_ADDRESS : DATASOURCE_ADDRESS;
            ManagementResourceRegistration subModel = registration.getSubModel(address);
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return subModel;
        }
    }

    private static boolean isLegacySecurityRequired(SecurityMetadata config) {
        boolean result;
        boolean bl = result = config != null && config instanceof org.jboss.as.connector.metadata.api.common.SecurityMetadata && !((org.jboss.as.connector.metadata.api.common.SecurityMetadata)config).isElytronEnabled();
        if (result) {
            String domain = config.resolveSecurityDomain();
            result = domain != null && domain.trim().length() > 0;
        }
        return result;
    }

    static {
        XA_DATASOURCE_ADDRESS = SUBSYSTEM_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)XA_DATA_SOURCE)});
        DATASOURCE_ADDRESS = SUBSYSTEM_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)DATA_SOURCE)});
    }
}

