/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.repository.ContentFilter;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ContentRepositoryElement;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.ExplodedContent;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.LocalDeploymentFileRepository;
import org.jboss.as.repository.TypedInputStream;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.CompositeContentRepository;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryExecutor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VirtualFile;

public class RemoteFileRepositoryService
implements CompositeContentRepository,
Service<ContentRepository> {
    private final InjectedValue<HostControllerClient> clientInjectedValue = new InjectedValue();
    private final File localDeploymentFolder;
    private final DeploymentFileRepository localRepository;
    private final ContentRepository contentRepository;
    private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

    public static void addService(ServiceTarget target, File localDeploymentContentsFolder, File localTmpFolder) {
        RemoteFileRepositoryService service = new RemoteFileRepositoryService(localDeploymentContentsFolder, localTmpFolder);
        target.addService(ContentRepository.SERVICE_NAME, (Service)service).addDependency(HostControllerConnectionService.SERVICE_NAME, HostControllerClient.class, service.clientInjectedValue).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    RemoteFileRepositoryService(File localDeploymentFolder, File localTmpFolder) {
        this.localDeploymentFolder = localDeploymentFolder;
        this.contentRepository = ContentRepository.Factory.create((File)localDeploymentFolder, (File)localTmpFolder);
        this.localRepository = new LocalDeploymentFileRepository(localDeploymentFolder);
    }

    public void start(StartContext context) throws StartException {
        HostControllerClient client = (HostControllerClient)this.clientInjectedValue.getValue();
        this.remoteFileRepositoryExecutor = client.getRemoteFileRepository();
        this.contentRepository.readWrite();
    }

    public void stop(StopContext context) {
        this.remoteFileRepositoryExecutor = null;
        this.contentRepository.readOnly();
    }

    public ContentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        RemoteFileRepositoryExecutor executor = this.remoteFileRepositoryExecutor;
        if (executor == null) {
            throw ServerLogger.ROOT_LOGGER.couldNotFindHcFileRepositoryConnection();
        }
        return this;
    }

    public byte[] addContent(InputStream stream) throws IOException {
        return this.contentRepository.addContent(stream);
    }

    public VirtualFile getContent(byte[] hash) {
        return this.contentRepository.getContent(hash);
    }

    public boolean syncContent(ContentReference reference) {
        if (!this.contentRepository.hasContent(reference.getHash())) {
            this.getDeploymentFiles(reference);
        }
        return this.contentRepository.hasContent(reference.getHash());
    }

    public boolean hasContent(byte[] hash) {
        return this.contentRepository.hasContent(hash);
    }

    public void removeContent(ContentReference reference) {
        this.contentRepository.removeContent(reference);
    }

    public final File[] getDeploymentFiles(ContentReference reference) {
        File root = this.getDeploymentRoot(reference);
        return root.listFiles();
    }

    public File getDeploymentRoot(ContentReference reference) {
        File file = this.localRepository.getDeploymentRoot(reference);
        if (!file.exists()) {
            return this.getFile(reference, (byte)40);
        }
        return file;
    }

    private File getFile(ContentReference reference, byte repoId) {
        RemoteFileRepositoryExecutor executor = this.remoteFileRepositoryExecutor;
        if (executor == null) {
            throw ServerLogger.ROOT_LOGGER.couldNotFindHcFileRepositoryConnection();
        }
        File file = this.remoteFileRepositoryExecutor.getFile(reference.getHexHash(), repoId, this.localDeploymentFolder);
        this.addContentReference(reference);
        return file;
    }

    public void deleteDeployment(ContentReference reference) {
        if (this.hasContent(reference.getHash())) {
            this.removeContent(reference);
        } else {
            this.localRepository.deleteDeployment(reference);
            this.removeContent(reference);
        }
    }

    public void addContentReference(ContentReference reference) {
        this.contentRepository.addContentReference(reference);
    }

    public Map<String, Set<String>> cleanObsoleteContent() {
        return this.contentRepository.cleanObsoleteContent();
    }

    public byte[] removeContentFromExploded(byte[] deploymentHash, List<String> paths) throws ExplodedContentException {
        return this.contentRepository.removeContentFromExploded(deploymentHash, paths);
    }

    public byte[] addContentToExploded(byte[] deploymentHash, List<ExplodedContent> addFiles, boolean overwrite) throws ExplodedContentException {
        return this.contentRepository.addContentToExploded(deploymentHash, addFiles, overwrite);
    }

    public void copyExplodedContent(byte[] hash, Path target) throws ExplodedContentException {
        this.contentRepository.copyExplodedContent(hash, target);
    }

    public void copyExplodedContentFiles(byte[] deploymentHash, List<String> relativePaths, Path target) throws ExplodedContentException {
        this.contentRepository.copyExplodedContentFiles(deploymentHash, relativePaths, target);
    }

    public byte[] explodeContent(byte[] hash) throws ExplodedContentException {
        return this.contentRepository.explodeContent(hash);
    }

    public TypedInputStream readContent(byte[] deploymentHash, String path) throws ExplodedContentException {
        return this.contentRepository.readContent(deploymentHash, path);
    }

    public byte[] explodeSubContent(byte[] deploymentHash, String relativePath) throws ExplodedContentException {
        return this.contentRepository.explodeSubContent(deploymentHash, relativePath);
    }

    public List<ContentRepositoryElement> listContent(byte[] deploymentHash, String path, ContentFilter filter) throws ExplodedContentException {
        return this.contentRepository.listContent(deploymentHash, path, filter);
    }
}

