/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Set;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.TransactionalOperationExecutor;
import org.hibernate.search.backend.impl.WorkQueuePerIndexSplitter;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;

public class TransactionalOperationExecutorSelector
implements IndexWorkVisitor<Void, TransactionalOperationExecutor> {
    public static final TransactionalOperationExecutorSelector INSTANCE = new TransactionalOperationExecutorSelector();
    private final AddSelectionExecutor addExecutor = new AddSelectionExecutor();
    private final DeleteSelectionExecutor deleteExecutor = new DeleteSelectionExecutor();
    private final OptimizeSelectionExecutor optimizeExecutor = new OptimizeSelectionExecutor();
    private final PurgeAllSelectionExecutor purgeExecutor = new PurgeAllSelectionExecutor();
    private final FlushSelectionExecutor flushExecutor = new FlushSelectionExecutor();
    private final DeleteByQuerySelectionExecutor deleteByQueryExecutor = new DeleteByQuerySelectionExecutor();

    private TransactionalOperationExecutorSelector() {
    }

    @Override
    public TransactionalOperationExecutor visitAddWork(AddLuceneWork addLuceneWork, Void p) {
        return this.addExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitUpdateWork(UpdateLuceneWork updateLuceneWork, Void p) {
        return this.addExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitDeleteWork(DeleteLuceneWork deleteLuceneWork, Void p) {
        return this.deleteExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitOptimizeWork(OptimizeLuceneWork optimizeLuceneWork, Void p) {
        return this.optimizeExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitPurgeAllWork(PurgeAllLuceneWork purgeAllLuceneWork, Void p) {
        return this.purgeExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitFlushWork(FlushLuceneWork flushLuceneWork, Void p) {
        return this.flushExecutor;
    }

    @Override
    public TransactionalOperationExecutor visitDeleteByQueryWork(DeleteByQueryLuceneWork deleteByQueryLuceneWork, Void p) {
        return this.deleteByQueryExecutor;
    }

    private class PurgeAllSelectionExecutor
    implements TransactionalOperationExecutor {
        private PurgeAllSelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                context.addToQueue(indexManager, work);
            }
        }
    }

    private static class FlushSelectionExecutor
    implements TransactionalOperationExecutor {
        private FlushSelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            Set<IndexManager> indexManagers = selector.all();
            for (IndexManager indexManager : indexManagers) {
                context.performStreamOperation(indexManager, work);
            }
        }
    }

    private static class OptimizeSelectionExecutor
    implements TransactionalOperationExecutor {
        private OptimizeSelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            Set<IndexManager> indexManagers = selector.all();
            for (IndexManager indexManager : indexManagers) {
                context.performStreamOperation(indexManager, work);
            }
        }
    }

    private class DeleteByQuerySelectionExecutor
    implements TransactionalOperationExecutor {
        private DeleteByQuerySelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                context.addToQueue(indexManager, work);
            }
        }
    }

    private class DeleteSelectionExecutor
    implements TransactionalOperationExecutor {
        private DeleteSelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                context.addToQueue(indexManager, work);
            }
        }
    }

    private class AddSelectionExecutor
    implements TransactionalOperationExecutor {
        private AddSelectionExecutor() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexManagerSelector selector, WorkQueuePerIndexSplitter context) {
            IndexManager indexManager = selector.forNew(work.getEntityType(), work.getId(), work.getIdInString(), work.getDocument());
            context.addToQueue(indexManager, work);
        }
    }
}

