/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.distribution;

import java.util.List;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.infinispan.spi.distribution.KeyDistribution;

public class ConsistentHashKeyDistribution
implements KeyDistribution {
    private final KeyPartitioner partitioner;
    private final ConsistentHash hash;

    public ConsistentHashKeyDistribution(KeyPartitioner partitioner, ConsistentHash hash) {
        this.partitioner = partitioner;
        this.hash = hash;
    }

    @Override
    public Address getPrimaryOwner(Object key) {
        int segment = this.partitioner.getSegment(key);
        return this.hash.locatePrimaryOwnerForSegment(segment);
    }

    @Override
    public List<Address> getOwners(Object key) {
        int segment = this.partitioner.getSegment(key);
        return this.hash.locateOwnersForSegment(segment);
    }
}

