/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.ZoneOffset;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ZoneOffsetMarshaller implements FieldSetMarshaller<ZoneOffset, ZoneOffset>
{
    INSTANCE;

    private static final int HOURS_INDEX = 0;
    private static final int MINUTES_INDEX = 1;
    private static final int SECONDS_INDEX = 2;
    private static final int FIELDS = 3;

    @Override
    public ZoneOffset getBuilder() {
        return ZoneOffset.UTC;
    }

    @Override
    public int getFields() {
        return 3;
    }

    @Override
    public ZoneOffset readField(ProtoStreamReader reader, int index, ZoneOffset offset) throws IOException {
        switch (index) {
            case 0: {
                return ZoneOffset.ofHours(reader.readSInt32());
            }
            case 1: {
                return ZoneOffset.ofTotalSeconds(reader.readSInt32() * 60);
            }
            case 2: {
                return ZoneOffset.ofTotalSeconds(reader.readSInt32());
            }
        }
        return offset;
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, ZoneOffset offset) throws IOException {
        int seconds = offset.getTotalSeconds();
        if (seconds != 0) {
            if (seconds % 60 == 0) {
                int minutes = seconds / 60;
                if (minutes % 60 == 0) {
                    int hours = minutes / 60;
                    writer.writeSInt32(startIndex + 0, hours);
                } else {
                    writer.writeSInt32(startIndex + 1, minutes);
                }
            } else {
                writer.writeSInt32(startIndex + 2, seconds);
            }
        }
    }
}

