/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AnyLiveNodeLocatorForReplication;
import org.apache.activemq.artemis.core.server.impl.BackupRecoveryJournalLoader;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.NamedLiveNodeLocatorForReplication;
import org.apache.activemq.artemis.core.server.impl.NamedNodeIdNodeLocator;
import org.apache.activemq.artemis.core.server.impl.ReplicationError;
import org.apache.activemq.artemis.core.server.impl.ServerConnectVoteHandler;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jboss.logging.Logger;

public final class SharedNothingBackupActivation
extends Activation
implements ReplicationEndpoint.ReplicationEndpointEventListener {
    private static final Logger logger = Logger.getLogger(SharedNothingBackupActivation.class);
    private ReplicaPolicy replicaPolicy;
    private ReplicationEndpoint replicationEndpoint;
    private final ActiveMQServerImpl activeMQServer;
    private SharedNothingBackupQuorum backupQuorum;
    private final boolean attemptFailBack;
    private final Map<String, Object> activationParams;
    private final IOCriticalErrorListener ioCriticalErrorListener;
    private String nodeID;
    ClusterControl clusterControl;
    private boolean closed;
    private volatile boolean backupUpToDate = true;
    private final NetworkHealthCheck networkHealthCheck;
    private final ReusableLatch backupSyncLatch = new ReusableLatch(0);

    public SharedNothingBackupActivation(ActiveMQServerImpl activeMQServer, boolean attemptFailBack, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener, ReplicaPolicy replicaPolicy, NetworkHealthCheck networkHealthCheck) {
        this.activeMQServer = activeMQServer;
        this.attemptFailBack = attemptFailBack;
        this.activationParams = activationParams;
        this.ioCriticalErrorListener = ioCriticalErrorListener;
        this.replicaPolicy = replicaPolicy;
        this.backupSyncLatch.setCount(1);
        this.networkHealthCheck = networkHealthCheck;
    }

    public void init() throws Exception {
        assert (this.replicationEndpoint == null);
        this.activeMQServer.resetNodeManager();
        this.backupUpToDate = false;
        this.replicationEndpoint = new ReplicationEndpoint(this.activeMQServer, this.attemptFailBack, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SharedNothingBackupQuorum.BACKUP_ACTIVATION signal;
            LiveNodeLocator nodeLocator;
            boolean scalingDown;
            logger.trace((Object)"SharedNothingBackupActivation..start");
            Object object = this.activeMQServer;
            synchronized (object) {
                this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
            }
            this.activeMQServer.getNodeManager().stop();
            this.activeMQServer.moveServerData(this.replicaPolicy.getMaxSavedReplicatedJournalsSize());
            this.activeMQServer.getNodeManager().start();
            object = this;
            synchronized (object) {
                if (this.closed) {
                    logger.trace((Object)"SharedNothingBackupActivation is closed, ignoring activation!");
                    return;
                }
            }
            boolean bl = scalingDown = this.replicaPolicy.getScaleDownPolicy() != null && this.replicaPolicy.getScaleDownPolicy().isEnabled();
            if (!this.activeMQServer.initialisePart1(scalingDown)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("could not initialize part1 " + scalingDown));
                }
                return;
            }
            SharedNothingBackupActivation sharedNothingBackupActivation = this;
            synchronized (sharedNothingBackupActivation) {
                if (this.closed) {
                    return;
                }
                this.backupQuorum = new SharedNothingBackupQuorum(this.activeMQServer.getNodeManager(), this.activeMQServer.getScheduledPool(), this.networkHealthCheck, this.replicaPolicy.getQuorumSize(), this.replicaPolicy.getVoteRetries(), this.replicaPolicy.getVoteRetryWait(), this.replicaPolicy.getQuorumVoteWait(), this.attemptFailBack);
                this.activeMQServer.getClusterManager().getQuorumManager().registerQuorum(this.backupQuorum);
                this.activeMQServer.getClusterManager().getQuorumManager().registerQuorumHandler(new ServerConnectVoteHandler(this.activeMQServer));
            }
            if (this.activationParams.get("REPLICATION_ENDPOINT") != null) {
                TopologyMember member = (TopologyMember)this.activationParams.get("REPLICATION_ENDPOINT");
                nodeLocator = new NamedNodeIdNodeLocator(member.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)member.getLive(), (Object)member.getBackup()));
            } else {
                nodeLocator = this.replicaPolicy.getGroupName() == null ? new AnyLiveNodeLocatorForReplication(this.backupQuorum, this.activeMQServer, this.replicaPolicy.getRetryReplicationWait()) : new NamedLiveNodeLocatorForReplication(this.replicaPolicy.getGroupName(), this.backupQuorum, this.replicaPolicy.getRetryReplicationWait());
            }
            ClusterController clusterController = this.activeMQServer.getClusterManager().getClusterController();
            clusterController.addClusterTopologyListenerForReplication(nodeLocator);
            logger.trace((Object)"Waiting on cluster connection");
            clusterController.awaitConnectionToReplicationCluster();
            logger.trace((Object)"Cluster Connected");
            clusterController.addIncomingInterceptorForReplication(new ReplicationError(nodeLocator));
            logger.debug((Object)"Starting backup manager");
            this.activeMQServer.getBackupManager().start();
            this.replicationEndpoint.setExecutor((Executor)this.activeMQServer.getExecutorFactory().getExecutor());
            EndpointConnector endpointConnector = new EndpointConnector();
            logger.debug((Object)"Starting Backup Server");
            ActiveMQServerLogger.LOGGER.backupServerStarted(this.activeMQServer.getVersion().getFullVersion(), this.activeMQServer.getNodeManager().getNodeId());
            this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Setting server state as started");
            }
            do {
                if (this.closed) {
                    logger.debug((Object)"Activation is closed, so giving up");
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"looking up the node through nodeLocator.locateNode()");
                }
                nodeLocator.locateNode();
                Pair<TransportConfiguration, TransportConfiguration> possibleLive = nodeLocator.getLiveConfiguration();
                this.nodeID = nodeLocator.getNodeID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Connecting towards a possible live, connection information=" + possibleLive + ", nodeID=" + this.nodeID));
                }
                if (!this.attemptFailBack) {
                    logger.debug((Object)("attemptFailback=false, nodeID=" + this.nodeID));
                    if (this.nodeID == null) {
                        logger.debug((Object)"Throwing a RuntimeException as nodeID==null ant attemptFailback=false");
                        throw new RuntimeException("Could not establish the connection");
                    }
                    this.activeMQServer.getNodeManager().setNodeID(this.nodeID);
                }
                if (possibleLive != null) {
                    this.clusterControl = SharedNothingBackupActivation.tryConnectToNodeInReplicatedCluster(clusterController, (TransportConfiguration)possibleLive.getA());
                    if (this.clusterControl == null) {
                        this.clusterControl = SharedNothingBackupActivation.tryConnectToNodeInReplicatedCluster(clusterController, (TransportConfiguration)possibleLive.getB());
                    }
                } else {
                    this.clusterControl = null;
                }
                if (this.clusterControl == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("sleeping " + clusterController.getRetryIntervalForReplicatedCluster() + " it should retry"));
                    }
                    Thread.sleep(clusterController.getRetryIntervalForReplicatedCluster());
                    signal = SharedNothingBackupQuorum.BACKUP_ACTIVATION.ALREADY_REPLICATING;
                    continue;
                }
                this.activeMQServer.getThreadPool().execute(endpointConnector);
                signal = this.backupQuorum.waitForStatusChange();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Got a signal " + (Object)((Object)signal) + " through backupQuorum.waitForStatusChange()"));
                }
                ActiveMQServerImpl.stopComponent(this.replicationEndpoint);
                if (!this.activeMQServer.isStarted() || signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.STOP) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("giving up on the activation:: activemqServer.isStarted=" + this.activeMQServer.isStarted() + " while signal = " + (Object)((Object)signal)));
                    }
                    return;
                }
                if (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAIL_OVER) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace((Object)"signal == FAIL_OVER, breaking the loop");
                    break;
                }
                if (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING || signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_RETRY) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Starting a new thread to stop the server!");
                    }
                    final SharedNothingBackupQuorum.BACKUP_ACTIVATION signalToStop = signal;
                    Thread startThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (logger.isTraceEnabled()) {
                                    logger.trace((Object)"Calling activeMQServer.stop() as initialization failed");
                                }
                                if (SharedNothingBackupActivation.this.activeMQServer.getState() != ActiveMQServer.SERVER_STATE.STOPPED && SharedNothingBackupActivation.this.activeMQServer.getState() != ActiveMQServer.SERVER_STATE.STOPPING) {
                                    if (signalToStop == SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_RETRY) {
                                        SharedNothingBackupActivation.this.activeMQServer.stop(false);
                                        logger.trace((Object)"The server was shutdown for a network isolation, we keep retrying");
                                        SharedNothingBackupActivation.this.activeMQServer.start();
                                    } else {
                                        SharedNothingBackupActivation.this.activeMQServer.stop();
                                    }
                                }
                            }
                            catch (Exception e) {
                                ActiveMQServerLogger.LOGGER.errorRestartingBackupServer(e, SharedNothingBackupActivation.this.activeMQServer);
                            }
                        }
                    });
                    startThread.start();
                    return;
                }
                this.clusterControl.close();
                this.backupQuorum.reset();
                if (this.replicationEndpoint.getChannel() == null) continue;
                this.replicationEndpoint.getChannel().close();
                this.replicationEndpoint.setChannel(null);
            } while (signal == SharedNothingBackupQuorum.BACKUP_ACTIVATION.ALREADY_REPLICATING);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Activation loop finished, current signal = " + (Object)((Object)signal)));
            }
            this.activeMQServer.getClusterManager().getQuorumManager().unRegisterQuorum(this.backupQuorum);
            if (!this.isRemoteBackupUpToDate()) {
                logger.debug((Object)"throwing exception for !isRemoteBackupUptoDate");
                throw ActiveMQMessageBundle.BUNDLE.backupServerNotInSync();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("@@@ setReplicaPolicy::" + this.replicaPolicy));
            }
            this.replicaPolicy.getReplicatedPolicy().setReplicaPolicy(this.replicaPolicy);
            this.activeMQServer.setHAPolicy(this.replicaPolicy.getReplicatedPolicy());
            ActiveMQServerImpl activeMQServerImpl = this.activeMQServer;
            synchronized (activeMQServerImpl) {
                if (!this.activeMQServer.isStarted()) {
                    logger.trace((Object)"Server is stopped, giving up right before becomingLive");
                    return;
                }
                ActiveMQServerLogger.LOGGER.becomingLive(this.activeMQServer);
                logger.trace((Object)"stop backup");
                this.activeMQServer.getNodeManager().stopBackup();
                logger.trace((Object)"start store manager");
                this.activeMQServer.getStorageManager().start();
                logger.trace((Object)"activated");
                this.activeMQServer.getBackupManager().activated();
                if (scalingDown) {
                    logger.trace((Object)"Scalling down...");
                    this.activeMQServer.initialisePart2(true);
                } else {
                    logger.trace((Object)"Setting up new activation");
                    this.activeMQServer.setActivation(new SharedNothingLiveActivation(this.activeMQServer, this.replicaPolicy.getReplicatedPolicy()));
                    logger.trace((Object)"initialize part 2");
                    this.activeMQServer.initialisePart2(false);
                    if (this.activeMQServer.getIdentity() != null) {
                        ActiveMQServerLogger.LOGGER.serverIsLive(this.activeMQServer.getIdentity());
                    } else {
                        ActiveMQServerLogger.LOGGER.serverIsLive();
                    }
                }
                logger.trace((Object)"completeActivation at the end");
                this.activeMQServer.completeActivation(true);
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(e.getMessage() + ", serverStarted=" + this.activeMQServer.isStarted()), (Throwable)e);
            }
            if ((e instanceof InterruptedException || e instanceof IllegalStateException) && !this.activeMQServer.isStarted()) {
                return;
            }
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    private static ClusterControl tryConnectToNodeInReplicatedCluster(ClusterController clusterController, TransportConfiguration tc) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Calling clusterController.connectToNodeInReplicatedCluster(" + tc + ")"));
            }
            if (tc != null) {
                return clusterController.connectToNodeInReplicatedCluster(tc);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        SharedNothingBackupActivation sharedNothingBackupActivation = this;
        synchronized (sharedNothingBackupActivation) {
            if (this.backupQuorum != null) {
                this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.STOP);
            }
            this.replicationEndpoint = null;
            this.closed = true;
        }
        if (this.activeMQServer.getHAPolicy().isBackup()) {
            NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
            this.activeMQServer.interruptActivationThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                nodeManagerInUse.stopBackup();
            }
        }
    }

    @Override
    public void preStorageClose() throws Exception {
        if (this.replicationEndpoint != null) {
            this.replicationEndpoint.stop();
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, ActiveMQServer parentServer) throws ActiveMQException {
        if (this.replicaPolicy.getScaleDownPolicy() != null && this.replicaPolicy.getScaleDownPolicy().isEnabled()) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.replicaPolicy.getScaleDownPolicy(), this.activeMQServer), this.activeMQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    @Override
    public void haStarted() {
        this.activeMQServer.getClusterManager().getClusterController().setReplicatedClusterName(this.replicaPolicy.getClusterName());
    }

    public boolean waitForBackupSync(long timeout, TimeUnit unit) throws InterruptedException {
        return this.backupSyncLatch.await(timeout, unit);
    }

    public void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        if (finalMessage == null) {
            this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING);
        } else {
            this.backupQuorum.failOver(finalMessage);
        }
    }

    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    public boolean isRemoteBackupUpToDate() {
        return this.backupUpToDate;
    }

    @Override
    public void onLiveNodeId(String nodeId) {
        this.backupQuorum.liveIDSet(nodeId);
    }

    @Override
    public void onRemoteBackupUpToDate(String nodeId, long ignoredActivationSequence) {
        this.backupQuorum.liveIDSet(nodeId);
        this.activeMQServer.getBackupManager().announceBackup();
        this.backupUpToDate = true;
        this.backupSyncLatch.countDown();
    }

    @Override
    public void onLiveStopping(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) throws ActiveMQException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Remote fail-over, got message=" + (Object)((Object)finalMessage) + ", backupUpToDate=" + this.backupUpToDate));
        }
        if (!this.activeMQServer.getHAPolicy().isBackup() || this.activeMQServer.getHAPolicy().isSharedStore()) {
            throw new ActiveMQInternalErrorException();
        }
        if (!this.backupUpToDate) {
            this.failOver(null);
        } else {
            this.failOver(finalMessage);
        }
    }

    @Override
    public boolean isReplicaSync() {
        return this.isRemoteBackupUpToDate();
    }

    private class EndpointConnector
    implements Runnable {
        private EndpointConnector() {
        }

        @Override
        public void run() {
            try {
                SharedNothingBackupActivation.this.clusterControl.getSessionFactory().setReconnectAttempts(1);
                SharedNothingBackupActivation.this.backupQuorum.setSessionFactory(SharedNothingBackupActivation.this.clusterControl.getSessionFactory());
                SharedNothingBackupActivation.this.clusterControl.authorize();
                this.connectToReplicationEndpoint(SharedNothingBackupActivation.this.clusterControl);
                SharedNothingBackupActivation.this.replicationEndpoint.start();
                SharedNothingBackupActivation.this.clusterControl.announceReplicatingBackupToLive(SharedNothingBackupActivation.this.attemptFailBack, SharedNothingBackupActivation.this.replicaPolicy.getClusterName());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.replicationStartProblem(e);
                SharedNothingBackupActivation.this.backupQuorum.causeExit(SharedNothingBackupQuorum.BACKUP_ACTIVATION.FAILURE_REPLICATING);
            }
        }

        private synchronized ReplicationEndpoint connectToReplicationEndpoint(ClusterControl control) throws Exception {
            if (!SharedNothingBackupActivation.this.activeMQServer.isStarted()) {
                return null;
            }
            if (!SharedNothingBackupActivation.this.activeMQServer.getHAPolicy().isBackup()) {
                throw ActiveMQMessageBundle.BUNDLE.serverNotBackupServer();
            }
            Channel replicationChannel = control.createReplicationChannel();
            replicationChannel.setHandler((ChannelHandler)SharedNothingBackupActivation.this.replicationEndpoint);
            if (SharedNothingBackupActivation.this.replicationEndpoint.getChannel() != null) {
                throw ActiveMQMessageBundle.BUNDLE.alreadyHaveReplicationServer();
            }
            SharedNothingBackupActivation.this.replicationEndpoint.setChannel(replicationChannel);
            return SharedNothingBackupActivation.this.replicationEndpoint;
        }
    }
}

