/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo;

import java.util.List;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.DefaultConfigVisitor;
import org.jboss.as.pojo.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.DescribedPojoPhase;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ParsedKernelDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        List kdXmlDescriptors = (List)unit.getAttachment(KernelDeploymentXmlDescriptor.ATTACHMENT_KEY);
        if (kdXmlDescriptors == null || kdXmlDescriptors.isEmpty()) {
            return;
        }
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw PojoLogger.ROOT_LOGGER.noModuleFound(unit);
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)unit.getAttachment(Attachments.REFLECTION_INDEX);
        if (index == null) {
            throw PojoLogger.ROOT_LOGGER.missingReflectionIndex(unit);
        }
        for (KernelDeploymentXmlDescriptor kdXmlDescriptor : kdXmlDescriptors) {
            List<BeanMetaDataConfig> beanConfigs = kdXmlDescriptor.getBeans();
            for (BeanMetaDataConfig beanConfig : beanConfigs) {
                this.describeBean(module, serviceTarget, index, beanConfig);
            }
        }
    }

    protected void describeBean(Module module, ServiceTarget serviceTarget, DeploymentReflectionIndex deploymentIndex, BeanMetaDataConfig beanConfig) {
        BeanState state = BeanState.NOT_INSTALLED;
        ServiceName describedServiceName = BeanMetaDataConfig.toBeanName(beanConfig.getName(), state.next());
        DescribedPojoPhase describedService = new DescribedPojoPhase(deploymentIndex, beanConfig);
        ServiceBuilder describedServiceBuilder = serviceTarget.addService(describedServiceName, (Service)describedService);
        describedService.registerAliases(describedServiceBuilder);
        DefaultConfigVisitor visitor = new DefaultConfigVisitor(describedServiceBuilder, state, module, deploymentIndex);
        beanConfig.visit(visitor);
        describedServiceBuilder.setInitialMode(beanConfig.getMode().getMode());
        describedServiceBuilder.install();
    }
}

