/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.UFC;
import org.jgroups.util.Credit;
import org.jgroups.util.NonBlockingCredit;

@MBean(description="Simple non-blocking flow control protocol based on a credit system")
public class UFC_NB
extends UFC {
    @Property(description="Max number of bytes of all queued messages for a given destination. If a given destination has no credits left and the message cannot be added to the queue because it is full, then the sender thread will be blocked until there is again space available in the queue, or the protocol is stopped.")
    protected int max_queue_size = 10000000;
    protected final Consumer<Message> send_function = msg -> this.down_prot.down((Message)msg);
    protected Future<?> credit_send_task;

    public int getMaxQueueSize() {
        return this.max_queue_size;
    }

    public UFC_NB setMaxQueueSize(int s) {
        this.max_queue_size = s;
        return this;
    }

    @ManagedAttribute(description="The number of messages currently queued due to insufficient credit")
    public int getNumberOfQueuedMessages() {
        return this.sent.values().stream().map(c -> ((NonBlockingCredit)c).getQueuedMessages()).reduce(0, Integer::sum);
    }

    @ManagedAttribute(description="The total size of all currently queued messages for all destinations")
    public int getQueuedSize() {
        return this.sent.values().stream().map(c -> ((NonBlockingCredit)c).getQueuedMessageSize()).reduce(0, Integer::sum);
    }

    @ManagedAttribute(description="The number of times messages have been queued due to insufficient credits")
    public int getNumberOfQueuings() {
        return this.sent.values().stream().map(c -> ((NonBlockingCredit)c).getEnqueuedMessages()).reduce(0, Integer::sum);
    }

    public boolean isQueuingTo(Address dest) {
        NonBlockingCredit cred = (NonBlockingCredit)this.sent.get(dest);
        return cred != null && cred.isQueuing();
    }

    public int getQueuedMessagesTo(Address dest) {
        NonBlockingCredit cred = (NonBlockingCredit)this.sent.get(dest);
        return cred != null ? cred.getQueuedMessages() : 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.max_block_time > 0L) {
            this.credit_send_task = this.getTransport().getTimer().scheduleWithFixedDelay(this::sendCreditRequestsIfNeeded, this.max_block_time, this.max_block_time, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.credit_send_task != null) {
            this.credit_send_task.cancel(true);
        }
    }

    @Override
    protected Object handleDownMessage(Message msg) {
        Address dest = msg.dest();
        if (dest == null) {
            this.log.error("%s doesn't handle multicast messages; passing message down", this.getClass().getSimpleName());
            return this.down_prot.down(msg);
        }
        Credit cred = (Credit)this.sent.get(dest);
        if (cred == null) {
            return this.down_prot.down(msg);
        }
        int length = msg.length();
        if (this.running && this.sent.containsKey(dest)) {
            if (cred.decrementIfEnoughCredits(msg, length, 0L)) {
                return this.down_prot.down(msg);
            }
            if (cred.needToSendCreditRequest(this.max_block_time)) {
                this.sendCreditRequest(dest, Math.max(0L, this.max_credits - cred.get()));
            }
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    protected <T extends Credit> T createCredit(int initial_credits) {
        return (T)new NonBlockingCredit(initial_credits, this.max_queue_size, new ReentrantLock(true), this.send_function);
    }

    protected void sendCreditRequestsIfNeeded() {
        this.sent.forEach((dest, c) -> {
            NonBlockingCredit cred = (NonBlockingCredit)c;
            if (cred.get() < this.min_credits && cred.isQueuing() && cred.needToSendCreditRequest(this.max_block_time)) {
                this.sendCreditRequest((Address)dest, Math.max(0L, this.max_credits - cred.get()));
            }
        });
    }
}

