/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.service;

import java.util.ArrayList;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.service.SecuredServiceRegistry;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceActivatorContextImpl;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceRegistryException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ServiceActivatorProcessor
implements DeploymentUnitProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServicesAttachment servicesAttachment = deploymentUnit.getAttachment(Attachments.SERVICES);
        if (servicesAttachment == null || servicesAttachment.getServiceImplementations(ServiceActivator.class.getName()).isEmpty()) {
            return;
        }
        Module module = deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        AttachmentList<DeploymentUnit> duList = deploymentUnit.getAttachment(Attachments.SUB_DEPLOYMENTS);
        ArrayList<String> serviceAcitvatorList = new ArrayList<String>();
        if (duList != null && !duList.isEmpty()) {
            for (DeploymentUnit du : duList) {
                ServicesAttachment duServicesAttachment = du.getAttachment(Attachments.SERVICES);
                for (String serv : duServicesAttachment.getServiceImplementations(ServiceActivator.class.getName())) {
                    serviceAcitvatorList.add(serv);
                }
            }
        }
        Object serviceRegistry = phaseContext.getServiceRegistry();
        if (WildFlySecurityManager.isChecking()) {
            serviceRegistry = new SecuredServiceRegistry((ServiceRegistry)serviceRegistry);
        }
        ServiceActivatorContextImpl serviceActivatorContext = new ServiceActivatorContextImpl(phaseContext.getServiceTarget(), serviceRegistry);
        ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            block7: for (ServiceActivator serviceActivator : module.loadService(ServiceActivator.class)) {
                try {
                    for (String serv : servicesAttachment.getServiceImplementations(ServiceActivator.class.getName())) {
                        if (serv.compareTo(serviceActivator.getClass().getName()) != 0 || serviceAcitvatorList.contains(serv)) continue;
                        serviceActivator.activate((ServiceActivatorContext)serviceActivatorContext);
                        continue block7;
                    }
                }
                catch (ServiceRegistryException e) {
                    throw new DeploymentUnitProcessingException(e);
                    return;
                }
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
        }
    }
}

