/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq.jms.JMSManagementHelper;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.jms.JsonUtil;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSTopicControlHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSTopicControlHandler INSTANCE = new JMSTopicControlHandler();
    private static final String REMOVE_MESSAGES = "remove-messages";
    private static final String DROP_ALL_SUBSCRIPTIONS = "drop-all-subscriptions";
    private static final String DROP_DURABLE_SUBSCRIPTION = "drop-durable-subscription";
    private static final String COUNT_MESSAGES_FOR_SUBSCRIPTION = "count-messages-for-subscription";
    private static final String LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON = "list-messages-for-subscription-as-json";
    private static final String LIST_MESSAGES_FOR_SUBSCRIPTION = "list-messages-for-subscription";
    private static final String LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-non-durable-subscriptions-as-json";
    private static final String LIST_NON_DURABLE_SUBSCRIPTIONS = "list-non-durable-subscriptions";
    private static final String LIST_DURABLE_SUBSCRIPTIONS_AS_JSON = "list-durable-subscriptions-as-json";
    private static final String LIST_DURABLE_SUBSCRIPTIONS = "list-durable-subscriptions";
    private static final String LIST_ALL_SUBSCRIPTIONS_AS_JSON = "list-all-subscriptions-as-json";
    private static final String LIST_ALL_SUBSCRIPTIONS = "list-all-subscriptions";
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    private static final AttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.CLIENT_ID).setRequired(true)).setValidator((ParameterValidator)new StringLengthValidator(1))).build();
    private static final AttributeDefinition SUBSCRIPTION_NAME = OperationDefinitionHelper.createNonEmptyStringAttribute("subscription-name");
    private static final AttributeDefinition QUEUE_NAME = OperationDefinitionHelper.createNonEmptyStringAttribute("queue-name");
    private static final AttributeDefinition PERSIST = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(ModelNode.FALSE)).build();
    private static final AttributeDefinition[] SUBSCRIPTION_REPLY_PARAMETER_DEFINITIONS = new AttributeDefinition[]{OperationDefinitionHelper.createNonEmptyStringAttribute("queueName"), OperationDefinitionHelper.createNonEmptyStringAttribute("clientID"), OperationDefinitionHelper.createNonEmptyStringAttribute("selector"), OperationDefinitionHelper.createNonEmptyStringAttribute("name"), SimpleAttributeDefinitionBuilder.create((String)"durable", (ModelType)ModelType.BOOLEAN).build(), SimpleAttributeDefinitionBuilder.create((String)"messageCount", (ModelType)ModelType.LONG).build(), SimpleAttributeDefinitionBuilder.create((String)"deliveringCount", (ModelType)ModelType.INT).build(), ObjectListAttributeDefinition.Builder.of((String)"consumers", (ObjectTypeAttributeDefinition)ObjectTypeAttributeDefinition.Builder.of((String)"consumers", (AttributeDefinition[])new AttributeDefinition[]{OperationDefinitionHelper.createNonEmptyStringAttribute("consumerID"), OperationDefinitionHelper.createNonEmptyStringAttribute("connectionID"), OperationDefinitionHelper.createNonEmptyStringAttribute("sessionID"), SimpleAttributeDefinitionBuilder.create((String)"browseOnly", (ModelType)ModelType.BOOLEAN).build(), SimpleAttributeDefinitionBuilder.create((String)"creationTime", (ModelType)ModelType.BOOLEAN).build()}).build()).build()};

    private JMSTopicControlHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block19: {
            if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
            String operationName = operation.require("operation").asString();
            String topicName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            boolean readOnly = context.getResourceRegistration().getOperationFlags(PathAddress.EMPTY_ADDRESS, operationName).contains(OperationEntry.Flag.READ_ONLY);
            ServiceController service = context.getServiceRegistry(!readOnly).getService(serviceName);
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
            ManagementService managementService = server.getManagementService();
            AddressControl control = (AddressControl)AddressControl.class.cast(managementService.getResource("address.jms.topic." + topicName));
            if (control == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
            }
            try {
                if (LIST_ALL_SUBSCRIPTIONS.equals(operationName)) {
                    String json = this.listAllSubscriptionsAsJSON(control, managementService);
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block19;
                }
                if (LIST_ALL_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(this.listAllSubscriptionsAsJSON(control, managementService));
                    break block19;
                }
                if (LIST_DURABLE_SUBSCRIPTIONS.equals(operationName)) {
                    String json = this.listDurableSubscriptionsAsJSON(control, managementService);
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block19;
                }
                if (LIST_DURABLE_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(this.listDurableSubscriptionsAsJSON(control, managementService));
                    break block19;
                }
                if (LIST_NON_DURABLE_SUBSCRIPTIONS.equals(operationName)) {
                    String json = this.listNonDurableSubscriptionsAsJSON(control, managementService);
                    ModelNode jsonAsNode = ModelNode.fromJSONString((String)json);
                    context.getResult().set(jsonAsNode);
                    break block19;
                }
                if (LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON.equals(operationName)) {
                    context.getResult().set(this.listNonDurableSubscriptionsAsJSON(control, managementService));
                    break block19;
                }
                if (LIST_MESSAGES_FOR_SUBSCRIPTION.equals(operationName)) {
                    String queueName = QUEUE_NAME.resolveModelAttribute(context, operation).asString();
                    String json = this.listMessagesForSubscriptionAsJSON(queueName, managementService);
                    context.getResult().set(ModelNode.fromJSONString((String)json));
                    break block19;
                }
                if (LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON.equals(operationName)) {
                    String queueName = QUEUE_NAME.resolveModelAttribute(context, operation).asString();
                    context.getResult().set(this.listMessagesForSubscriptionAsJSON(queueName, managementService));
                    break block19;
                }
                if (COUNT_MESSAGES_FOR_SUBSCRIPTION.equals(operationName)) {
                    String clientId = CLIENT_ID.resolveModelAttribute(context, operation).asString();
                    String subscriptionName = SUBSCRIPTION_NAME.resolveModelAttribute(context, operation).asString();
                    String filter = OperationDefinitionHelper.resolveFilter(context, operation);
                    context.getResult().set(this.countMessagesForSubscription(clientId, subscriptionName, filter, managementService));
                    break block19;
                }
                if (DROP_DURABLE_SUBSCRIPTION.equals(operationName)) {
                    String clientId = CLIENT_ID.resolveModelAttribute(context, operation).asString();
                    String subscriptionName = SUBSCRIPTION_NAME.resolveModelAttribute(context, operation).asString();
                    this.dropDurableSubscription(clientId, subscriptionName, managementService);
                    context.getResult();
                    break block19;
                }
                if (DROP_ALL_SUBSCRIPTIONS.equals(operationName)) {
                    this.dropAllSubscriptions(control, managementService);
                    context.getResult();
                    break block19;
                }
                if (REMOVE_MESSAGES.equals(operationName)) {
                    String filter = OperationDefinitionHelper.resolveFilter(context, operation);
                    context.getResult().set(this.removeMessages(filter, control, managementService));
                    break block19;
                }
                if (PAUSE.equals(operationName)) {
                    this.pause(control, PERSIST.resolveModelAttribute(context, operation).asBoolean());
                    context.getResult();
                    break block19;
                }
                if (RESUME.equals(operationName)) {
                    this.resume(control);
                    context.getResult();
                    break block19;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_ALL_SUBSCRIPTIONS, resolver).setReplyType(ModelType.LIST).setReplyParameters(SUBSCRIPTION_REPLY_PARAMETER_DEFINITIONS).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_ALL_SUBSCRIPTIONS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_DURABLE_SUBSCRIPTIONS, resolver).setReplyType(ModelType.LIST).setReplyParameters(SUBSCRIPTION_REPLY_PARAMETER_DEFINITIONS).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_DURABLE_SUBSCRIPTIONS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_NON_DURABLE_SUBSCRIPTIONS, resolver).setReplyType(ModelType.LIST).setReplyParameters(SUBSCRIPTION_REPLY_PARAMETER_DEFINITIONS).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_NON_DURABLE_SUBSCRIPTIONS_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGES_FOR_SUBSCRIPTION, resolver).setParameters(new AttributeDefinition[]{QUEUE_NAME}).setReplyType(ModelType.LIST).setReplyParameters(JMSManagementHelper.JMS_MESSAGE_PARAMETERS).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGES_FOR_SUBSCRIPTION_AS_JSON, resolver).setParameters(new AttributeDefinition[]{QUEUE_NAME}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(COUNT_MESSAGES_FOR_SUBSCRIPTION, resolver).setParameters(new AttributeDefinition[]{CLIENT_ID, SUBSCRIPTION_NAME, CommonAttributes.FILTER}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(DROP_DURABLE_SUBSCRIPTION, resolver).setParameters(new AttributeDefinition[]{CLIENT_ID, SUBSCRIPTION_NAME}).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(DROP_ALL_SUBSCRIPTIONS, resolver).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(REMOVE_MESSAGES, resolver).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(PAUSE, resolver).setParameters(new AttributeDefinition[]{PERSIST}).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(RESUME, resolver).build(), (OperationStepHandler)this);
    }

    private int removeMessages(String filterStr, AddressControl addressControl, ManagementService managementService) throws Exception {
        String[] queues;
        String filter = JMSTopicControlHandler.createFilterFromJMSSelector(filterStr);
        int count = 0;
        for (String queue : queues = addressControl.getQueueNames()) {
            QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue." + queue);
            if (coreQueueControl == null) continue;
            count += coreQueueControl.removeMessages(filter);
        }
        return count;
    }

    private long countMessagesForSubscription(String clientID, String subscriptionName, String filterStr, ManagementService managementService) throws Exception {
        SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription((boolean)true, (String)clientID, (String)subscriptionName);
        QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName + " for clientID " + clientID);
        }
        String filter = JMSTopicControlHandler.createFilterFromJMSSelector(filterStr);
        return coreQueueControl.countMessages(filter);
    }

    private void dropAllSubscriptions(AddressControl addressControl, ManagementService managementService) throws Exception {
        String[] queues;
        ActiveMQServerControl serverControl = (ActiveMQServerControl)managementService.getResource("broker");
        for (String queue : queues = addressControl.getQueueNames()) {
            if (queue.equals(addressControl.getAddress())) continue;
            serverControl.destroyQueue(queue);
        }
    }

    private void dropDurableSubscription(String clientID, String subscriptionName, ManagementService managementService) throws Exception {
        SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription((boolean)true, (String)clientID, (String)subscriptionName);
        QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName + " for clientID " + clientID);
        }
        ActiveMQServerControl serverControl = (ActiveMQServerControl)managementService.getResource("broker");
        serverControl.destroyQueue(queueName.toString(), true);
    }

    private String listAllSubscriptionsAsJSON(AddressControl addressControl, ManagementService managementService) {
        return this.listSubscribersInfosAsJSON(JMSTopicReadAttributeHandler.DurabilityType.ALL, addressControl, managementService);
    }

    private String listDurableSubscriptionsAsJSON(AddressControl addressControl, ManagementService managementService) throws Exception {
        return this.listSubscribersInfosAsJSON(JMSTopicReadAttributeHandler.DurabilityType.DURABLE, addressControl, managementService);
    }

    private String listNonDurableSubscriptionsAsJSON(AddressControl addressControl, ManagementService managementService) throws Exception {
        return this.listSubscribersInfosAsJSON(JMSTopicReadAttributeHandler.DurabilityType.NON_DURABLE, addressControl, managementService);
    }

    public String listMessagesForSubscriptionAsJSON(String queueName, ManagementService managementService) throws Exception {
        return JsonUtil.toJSON(this.listMessagesForSubscription(queueName, managementService));
    }

    private Map<String, Object>[] listMessagesForSubscription(String queueName, ManagementService managementService) throws Exception {
        QueueControl coreQueueControl = (QueueControl)managementService.getResource("queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName);
        }
        Map[] coreMessages = coreQueueControl.listMessages(null);
        Map[] jmsMessages = new Map[coreMessages.length];
        int i = 0;
        for (Map coreMessage : coreMessages) {
            jmsMessages[i++] = ActiveMQMessage.coreMaptoJMSMap((Map)coreMessage);
        }
        return jmsMessages;
    }

    private String listSubscribersInfosAsJSON(JMSTopicReadAttributeHandler.DurabilityType durability, AddressControl addressControl, ManagementService managementService) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        try {
            List<QueueControl> queues = JMSTopicReadAttributeHandler.getQueues(durability, addressControl, managementService);
            for (QueueControl queue : queues) {
                String clientID = null;
                String subName = null;
                if (queue.isDurable() && RoutingType.MULTICAST.toString().equals(queue.getRoutingType())) {
                    Pair pair = ActiveMQDestination.decomposeQueueNameForDurableSubscription((String)queue.getName());
                    clientID = (String)pair.getA();
                    subName = (String)pair.getB();
                } else if (RoutingType.MULTICAST.toString().equals(queue.getRoutingType())) {
                    clientID = "ActiveMQ";
                    subName = "ActiveMQ";
                }
                String filter = queue.getFilter() != null ? queue.getFilter() : null;
                JsonObjectBuilder info = Json.createObjectBuilder().add("queueName", queue.getName()).add("durable", queue.isDurable()).add("messageCount", queue.getMessageCount()).add("deliveringCount", queue.getDeliveringCount()).add("consumers", queue.listConsumersAsJSON());
                if (clientID == null) {
                    info.addNull("clientID");
                } else {
                    info.add("clientID", clientID);
                }
                if (filter == null) {
                    info.addNull("selector");
                } else {
                    info.add("selector", filter);
                }
                if (subName == null) {
                    info.addNull("name");
                } else {
                    info.add("name", subName);
                }
                array.add((JsonValue)info.build());
            }
        }
        catch (Exception e) {
            JMSTopicControlHandler.rethrow(e);
        }
        return array.build().toString();
    }

    private void pause(AddressControl control, boolean persist) {
        try {
            control.pause(persist);
        }
        catch (Exception e) {
            JMSTopicControlHandler.rethrow(e);
        }
    }

    private void resume(AddressControl control) {
        try {
            control.resume();
        }
        catch (Exception e) {
            JMSTopicControlHandler.rethrow(e);
        }
    }

    private static String createFilterFromJMSSelector(String selectorStr) throws ActiveMQException {
        return selectorStr == null || selectorStr.trim().length() == 0 ? null : SelectorTranslator.convertToActiveMQFilterString((String)selectorStr);
    }

    public static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }
}

