/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Month;
import java.time.MonthDay;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.time.TimeExternalizerProvider;

public class MonthDayExternalizer
implements Externalizer<MonthDay> {
    public void writeObject(ObjectOutput output, MonthDay value) throws IOException {
        TimeExternalizerProvider.MONTH.cast(Month.class).writeObject(output, (Object)value.getMonth());
        IndexSerializer.UNSIGNED_BYTE.writeInt(output, value.getDayOfMonth());
    }

    public MonthDay readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Month month = (Month)TimeExternalizerProvider.MONTH.cast(Month.class).readObject(input);
        int day = IndexSerializer.UNSIGNED_BYTE.readInt(input);
        return MonthDay.of(month, day);
    }

    public Class<MonthDay> getTargetClass() {
        return MonthDay.class;
    }

    public OptionalInt size(MonthDay value) {
        return OptionalInt.of(TimeExternalizerProvider.MONTH.size(value.getMonth()).getAsInt() + IndexSerializer.UNSIGNED_BYTE.size(value.getDayOfMonth()));
    }
}

