/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReaderContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriterContext;
import org.wildfly.clustering.marshalling.protostream.SizeComputingProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class ProtoStreamByteBufferMarshaller
implements ByteBufferMarshaller {
    private final ImmutableSerializationContext context;

    public ProtoStreamByteBufferMarshaller(ImmutableSerializationContext context) {
        this.context = context;
    }

    public OptionalInt size(Object value) {
        try (ProtoStreamWriterContext.Factory factory = ProtoStreamWriterContext.FACTORY.get();){
            ProtoStreamMarshaller marshaller = (ProtoStreamMarshaller)this.context.getMarshaller(Any.class);
            SizeComputingProtoStreamWriter writer = new SizeComputingProtoStreamWriter(this.context);
            try {
                marshaller.writeTo(writer, new Any(value));
                OptionalInt optionalInt = writer.get();
                return optionalInt;
            }
            catch (IOException e) {
                OptionalInt optionalInt = OptionalInt.empty();
                if (factory != null) {
                    factory.close();
                }
                return optionalInt;
            }
        }
    }

    public boolean isMarshallable(Object object) {
        if (object == null || object instanceof Class) {
            return true;
        }
        Class<?> targetClass = object.getClass();
        if (AnyField.fromJavaType(targetClass) != null) {
            return true;
        }
        if (targetClass.isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (this.isMarshallable(Array.get(object, i))) continue;
                return false;
            }
            return true;
        }
        if (Proxy.isProxyClass(targetClass)) {
            return this.isMarshallable(Proxy.getInvocationHandler(object));
        }
        while (targetClass != null) {
            if (this.context.canMarshall(targetClass)) {
                return true;
            }
            targetClass = targetClass.getSuperclass();
        }
        return false;
    }

    public Object readFrom(InputStream input) throws IOException {
        try (ProtoStreamReaderContext context = ProtoStreamReaderContext.INSTANCE.get();){
            Object object = ((Any)ProtobufUtil.readFrom((ImmutableSerializationContext)this.context, (InputStream)input, Any.class)).get();
            return object;
        }
    }

    public void writeTo(OutputStream output, Object object) throws IOException {
        try (ProtoStreamWriterContext.Factory factory = ProtoStreamWriterContext.FACTORY.get();){
            ProtobufUtil.writeTo((ImmutableSerializationContext)this.context, (OutputStream)output, (Object)new Any(object));
        }
    }
}

