/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.annotated.slim;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedType;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AnnotatedCallableMarshaller<X, E extends Executable, T extends SlimAnnotatedType<X>, C extends AnnotatedCallable<? super X>, SC extends AnnotatedCallable<X>>
implements ProtoStreamMarshaller<SC> {
    private static final int TYPE_INDEX = 1;
    private static final int DECLARING_TYPE_INDEX = 2;
    private static final int POSITION_INDEX = 3;
    private final Class<SC> targetClass;
    private final Class<T> typeClass;
    private final CallableLocator<X, E> locator;
    private final Function<T, Set<C>> enumerator;
    private final ToIntFunction<E> indexer;

    public AnnotatedCallableMarshaller(Class<SC> targetClass, Class<T> typeClass, CallableLocator<X, E> locator, Function<T, Set<C>> enumerator, ToIntFunction<E> indexer) {
        this.targetClass = targetClass;
        this.typeClass = typeClass;
        this.locator = locator;
        this.enumerator = enumerator;
        this.indexer = indexer;
    }

    public Class<? extends SC> getJavaClass() {
        return this.targetClass;
    }

    public SC readFrom(ProtoStreamReader reader) throws IOException {
        SlimAnnotatedType type = null;
        Class declaringType = null;
        int position = 0;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    type = (SlimAnnotatedType)reader.readObject(this.typeClass);
                    continue block5;
                }
                case 2: {
                    declaringType = (Class)reader.readObject(Class.class);
                    continue block5;
                }
                case 3: {
                    position = reader.readUInt32();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        E callable = this.locator.lookup(position, declaringType != null ? declaringType : type.getJavaClass());
        for (AnnotatedCallable annotatedCallable : this.enumerator.apply(type)) {
            if (!annotatedCallable.getJavaMember().equals(callable)) continue;
            return (SC)((AnnotatedCallable)this.targetClass.cast(annotatedCallable));
        }
        throw new IllegalStateException();
    }

    public void writeTo(ProtoStreamWriter writer, SC callable) throws IOException {
        Executable executable;
        AnnotatedType type = callable.getDeclaringType();
        if (type != null) {
            writer.writeObject(1, (Object)type);
        }
        if ((executable = (Executable)callable.getJavaMember()) != null) {
            int position;
            Class<?> declaringType = executable.getDeclaringClass();
            if (declaringType != type.getJavaClass()) {
                writer.writeObject(2, declaringType);
            }
            if ((position = this.indexer.applyAsInt(executable)) > 0) {
                writer.writeUInt32(3, position);
            }
        }
    }

    static interface CallableLocator<X, E extends Executable> {
        public E lookup(int var1, Class<X> var2);
    }
}

