/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.injection.WSComponentDescription;
import org.jboss.as.xts.XTSEJBInterceptor;
import org.jboss.as.xts.XTSPOJOInterceptor;
import org.jboss.narayana.txframework.api.annotation.service.ServiceRequest;

public class XTSInterceptorDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component instanceof SessionBeanComponentDescription) {
                this.registerSessionBeanInterceptors((SessionBeanComponentDescription)component);
            }
            if (!(component instanceof WSComponentDescription)) continue;
            this.registerWSPOJOInterceptors((WSComponentDescription)component);
        }
    }

    private void registerSessionBeanInterceptors(SessionBeanComponentDescription componentDescription) {
        if (componentDescription.isStateless()) {
            componentDescription.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    for (Method method : configuration.getDefinedComponentMethods()) {
                        if (!XTSInterceptorDeploymentProcessor.this.methodHasServiceRequestAnnotation(method)) continue;
                        configuration.addComponentInterceptor(method, XTSEJBInterceptor.FACTORY, 2305);
                        configuration.getInterceptorContextKeys().add("org.jboss.as.txf.InterceptorContextKey");
                    }
                }
            });
        }
    }

    private void registerWSPOJOInterceptors(WSComponentDescription componentDescription) {
        for (ViewDescription view : componentDescription.getViews()) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                        if (!XTSInterceptorDeploymentProcessor.this.methodHasServiceRequestAnnotation(method)) continue;
                        configuration.addViewInterceptor(method, XTSPOJOInterceptor.FACTORY, 1793);
                    }
                }
            });
        }
    }

    private boolean methodHasServiceRequestAnnotation(Method method) {
        for (Annotation a : method.getDeclaredAnnotations()) {
            if (!(a instanceof ServiceRequest)) continue;
            return true;
        }
        return false;
    }
}

