/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.extension.AbstractLegacyExtension;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.picketlink.federation.FederationSubsystemRootResourceDefinition;
import org.wildfly.extension.picketlink.federation.Namespace;
import org.wildfly.extension.picketlink.federation.model.FederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.parser.FederationSubsystemWriter;

public final class FederationExtension
extends AbstractLegacyExtension {
    public static final String SUBSYSTEM_NAME = "picketlink-federation";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"picketlink-federation");
    private static final String RESOURCE_NAME = FederationExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)Namespace.CURRENT.getMajor(), (int)Namespace.CURRENT.getMinor());
    public static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)2, (int)0, (int)0);

    public FederationExtension() {
        super("org.wildfly.extension.picketlink", new String[]{SUBSYSTEM_NAME});
    }

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, keyPrefix, RESOURCE_NAME, FederationExtension.class.getClassLoader(), true, true);
    }

    protected Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION, true);
        ManagementResourceRegistration subsystem = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new FederationSubsystemRootResourceDefinition());
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)FederationSubsystemWriter.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_0(subsystemRegistration);
        }
        return Collections.singleton(subsystem);
    }

    private void registerTransformers_1_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder federationTransfDescBuilder = builder.addChildResource((ResourceDefinition)new FederationResourceDefinition());
        ResourceTransformationDescriptionBuilder keyStoreTransfDescBuilder = federationTransfDescBuilder.addChildResource((ResourceDefinition)KeyStoreProviderResourceDefinition.INSTANCE);
        keyStoreTransfDescBuilder.rejectChildResource(KeyResourceDefinition.INSTANCE.getPathElement());
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)ModelVersion.create((int)1, (int)0));
    }

    protected void initializeLegacyParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUri(), Namespace.CURRENT::getXMLReader);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.PICKETLINK_FEDERATION_1_1.getUri(), Namespace.PICKETLINK_FEDERATION_1_1::getXMLReader);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.PICKETLINK_FEDERATION_1_0.getUri(), Namespace.PICKETLINK_FEDERATION_1_0::getXMLReader);
    }
}

