/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class Attachments {
    public static final Attachments IMMUTABLE_ATTACHMENTS = new Attachments(true);
    private final boolean immutable;
    private final List<String> paths = new ArrayList<String>();
    private final List<Consumer<Attachments>> listeners = new ArrayList<Consumer<Attachments>>();

    private Attachments(boolean immutable) {
        this.immutable = immutable;
    }

    public Attachments() {
        this(false);
    }

    public int addFileAttachment(String path) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Attachments can't be mutated");
        }
        this.paths.add(path);
        return this.paths.size() - 1;
    }

    public List<String> getAttachedFiles() {
        return Collections.unmodifiableList(this.paths);
    }

    public void addConsumer(Consumer<Attachments> listener) {
        this.listeners.add(listener);
    }

    public void done() {
        for (Consumer<Attachments> l : this.listeners) {
            l.accept(this);
        }
    }
}

