/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.retry.RetryingInvoker;
import org.wildfly.clustering.ee.infinispan.logging.Logger;
import org.wildfly.clustering.ee.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.common.function.ExceptionSupplier;

public class PrimaryOwnerScheduler<I, K, M>
implements Scheduler<I, M> {
    private static final Invoker INVOKER = new RetryingInvoker(new Duration[]{Duration.ZERO, Duration.ofMillis(10L), Duration.ofMillis(100L)});
    private final Function<K, Node> primaryOwnerLocator;
    private final Function<I, K> keyFactory;
    private final CommandDispatcher<org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, M>> dispatcher;
    private final BiFunction<I, M, ScheduleCommand<I, M>> scheduleCommandFactory;

    public <C, L> PrimaryOwnerScheduler(CommandDispatcherFactory dispatcherFactory, String name, org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, M> scheduler, Function<K, Node> primaryOwnerLocator, Function<I, K> keyFactory) {
        this(dispatcherFactory, name, scheduler, primaryOwnerLocator, keyFactory, ScheduleWithTransientMetaDataCommand::new);
    }

    public <C, L> PrimaryOwnerScheduler(CommandDispatcherFactory dispatcherFactory, String name, org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, M> scheduler, Function<K, Node> primaryOwnerLocator, Function<I, K> keyFactory, BiFunction<I, M, ScheduleCommand<I, M>> scheduleCommandFactory) {
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)name, scheduler, keyFactory.apply(null).getClass().getClassLoader());
        this.primaryOwnerLocator = primaryOwnerLocator;
        this.keyFactory = keyFactory;
        this.scheduleCommandFactory = scheduleCommandFactory;
    }

    public void schedule(I id, M metaData) {
        try {
            this.executeOnPrimaryOwner(id, this.scheduleCommandFactory.apply(id, metaData));
        }
        catch (Exception e) {
            Logger.ROOT_LOGGER.failedToSchedule(e, id);
        }
    }

    public void cancel(I id) {
        try {
            this.executeOnPrimaryOwner(id, new CancelCommand(id)).toCompletableFuture().join();
        }
        catch (Exception e) {
            Logger.ROOT_LOGGER.failedToCancel(e, id);
        }
    }

    private CompletionStage<Void> executeOnPrimaryOwner(I id, final Command<Void, org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, M>> command) throws CommandDispatcherException {
        final K key = this.keyFactory.apply(id);
        final Function<K, Node> primaryOwnerLocator = this.primaryOwnerLocator;
        final CommandDispatcher<org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, M>> dispatcher = this.dispatcher;
        ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException> action = new ExceptionSupplier<CompletionStage<Void>, CommandDispatcherException>(){

            public CompletionStage<Void> get() throws CommandDispatcherException {
                Node node = (Node)primaryOwnerLocator.apply(key);
                return dispatcher.executeOnMember(command, node);
            }
        };
        return (CompletionStage)INVOKER.invoke((ExceptionSupplier)action);
    }

    public void close() {
        this.dispatcher.close();
        ((org.wildfly.clustering.ee.infinispan.scheduler.Scheduler)this.dispatcher.getContext()).close();
    }
}

