/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.ignored;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRoot;
import org.jboss.as.host.controller.ignored.IgnoredDomainTypeResourceDefinition;
import org.jboss.dmr.ModelNode;

public class IgnoredDomainResourceRegistry {
    private final LocalHostControllerInfo localHostControllerInfo;
    private volatile IgnoredDomainResourceRoot rootResource;
    private IgnoredClonedProfileRegistry ignoredClonedProfileRegistry = new IgnoredClonedProfileRegistry();

    public IgnoredDomainResourceRegistry(LocalHostControllerInfo localHostControllerInfo) {
        this.localHostControllerInfo = localHostControllerInfo;
    }

    public boolean isResourceExcluded(PathAddress address) {
        if (!this.localHostControllerInfo.isMasterDomainController() && address.size() > 0) {
            IgnoreDomainResourceTypeResource typeResource;
            IgnoredDomainResourceRoot root = this.rootResource;
            PathElement firstElement = address.getElement(0);
            IgnoreDomainResourceTypeResource ignoreDomainResourceTypeResource = typeResource = root == null ? null : root.getChildInternal(firstElement.getKey());
            if (typeResource != null && typeResource.hasName(firstElement.getValue())) {
                return true;
            }
        }
        return false;
    }

    public void registerResources(ManagementResourceRegistration parentRegistration) {
        parentRegistration.registerSubModel((org.jboss.as.controller.ResourceDefinition)new ResourceDefinition());
    }

    public Resource.ResourceEntry getRootResource() {
        IgnoredDomainResourceRoot root;
        this.rootResource = root = new IgnoredDomainResourceRoot(this);
        return root;
    }

    public ModelNode getIgnoredResourcesAsModel() {
        IgnoredDomainResourceRoot root = this.rootResource;
        ModelNode model = root == null ? new ModelNode() : Resource.Tools.readModel((Resource)root);
        return model;
    }

    void publish(IgnoredDomainResourceRoot root) {
        this.rootResource = root;
    }

    boolean isMaster() {
        return this.localHostControllerInfo.isMasterDomainController();
    }

    public IgnoredClonedProfileRegistry getIgnoredClonedProfileRegistry() {
        return this.ignoredClonedProfileRegistry;
    }

    public class IgnoredClonedProfileRegistry {
        private volatile Set<String> ignoredClonedProfiles = Collections.synchronizedSet(new HashSet());
        private volatile Set<String> currentTxIgnoredClonedProfiles;
        private volatile boolean reloadRequired;

        private IgnoredClonedProfileRegistry() {
        }

        public boolean checkIgnoredProfileClone(ModelNode operation) {
            PathElement first;
            PathAddress addr;
            if (!IgnoredDomainResourceRegistry.this.localHostControllerInfo.isMasterDomainController() && (addr = PathAddress.pathAddress((ModelNode)operation.get("address"))).size() > 0 && (first = addr.getElement(0)).getKey().equals("profile")) {
                String name = operation.get("operation").asString();
                if (name.equals("clone") && IgnoredDomainResourceRegistry.this.isResourceExcluded(addr)) {
                    String profileName = operation.get("to-profile").asString();
                    if (!IgnoredDomainResourceRegistry.this.isResourceExcluded(PathAddress.pathAddress((String)"profile", (String)profileName))) {
                        this.getIgnoredClonedProfiles(true).add(profileName);
                        this.reloadRequired = true;
                        return true;
                    }
                } else {
                    if (name.equals("remove") && addr.size() == 1) {
                        return this.getIgnoredClonedProfiles(true).remove(first.getValue());
                    }
                    return this.getIgnoredClonedProfiles(false).contains(first.getValue());
                }
            }
            return false;
        }

        public void initializeModelSync() {
            if (!IgnoredDomainResourceRegistry.this.localHostControllerInfo.isMasterDomainController()) {
                this.getIgnoredClonedProfiles(true).clear();
            }
        }

        public void complete(boolean rollback) {
            if (!IgnoredDomainResourceRegistry.this.localHostControllerInfo.isMasterDomainController()) {
                if (!rollback && this.currentTxIgnoredClonedProfiles != null) {
                    this.ignoredClonedProfiles = this.currentTxIgnoredClonedProfiles;
                }
                this.currentTxIgnoredClonedProfiles = null;
                this.reloadRequired = false;
            }
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        private Set<String> getIgnoredClonedProfiles(boolean write) {
            if (this.currentTxIgnoredClonedProfiles != null) {
                return this.currentTxIgnoredClonedProfiles;
            }
            if (write) {
                this.currentTxIgnoredClonedProfiles = Collections.synchronizedSet(new HashSet<String>(this.ignoredClonedProfiles));
                return this.currentTxIgnoredClonedProfiles;
            }
            return this.ignoredClonedProfiles;
        }
    }

    private class ResourceDefinition
    extends SimpleResourceDefinition {
        public ResourceDefinition() {
            super(IgnoredDomainResourceRoot.PATH_ELEMENT, HostResolver.getResolver("ignored-resources"));
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerSubModel((org.jboss.as.controller.ResourceDefinition)new IgnoredDomainTypeResourceDefinition());
        }
    }
}

