/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.core.handlers;

import java.util.List;
import org.projectodd.vdx.core.DocElement;
import org.projectodd.vdx.core.ErrorHandler;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.ValidationError;

public class DuplicateElementHandler
implements ErrorHandler {
    @Override
    public ErrorHandler.HandledResult handle(ValidationContext ctx, ValidationError error) {
        String el = error.element().getLocalPart();
        String attr = error.attribute() != null ? error.attribute().getLocalPart() : null;
        String attrValue = error.attributeValue();
        ErrorHandler.HandledResult result = ErrorHandler.HandledResult.from(error);
        List<DocElement> docPath = ctx.pathToDocElement(error.element(), error.position());
        if (attr != null) {
            result.addPrimaryMessage(I18N.Key.ELEMENT_WITH_ATTRIBUTE_DUPLICATED, el, attr, attrValue);
        } else {
            String parentName = "parent";
            if (!docPath.isEmpty() && docPath.size() > 1) {
                parentName = docPath.get(docPath.size() - 2).name();
            }
            result.addPrimaryMessage(I18N.Key.ELEMENT_DUPLICATED, el, parentName);
        }
        if (!docPath.isEmpty()) {
            List<DocElement> firstPath;
            List<List<DocElement>> docElements = ctx.docElementSiblings(docPath, e -> e.qname().equals(error.element()) && (attr == null || attrValue.equals(e.attributes().get(attr))));
            if (!docElements.isEmpty() && !(firstPath = docElements.get(0)).isEmpty()) {
                DocElement otherEl = firstPath.get(firstPath.size() - 1);
                if (attr != null) {
                    result.addSecondaryMessage(I18N.Key.ELEMENT_WITH_ATTRIBUTE_DUPLICATED_FIRST_OCCURRENCE, el, attr);
                } else {
                    result.addSecondaryMessage(I18N.Key.ELEMENT_DUPLICATED_FIRST_OCCURRENCE, el);
                }
                result.addSecondaryResult(new ErrorHandler.HandledResult(otherEl.startPosition().line, otherEl.startPosition().col, null));
            }
        } else {
            result.possiblyMalformed(true);
        }
        return result;
    }
}

