/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.integration.ParticipantsContainer;
import org.jboss.narayana.rest.integration.api.VolatileParticipant;

@Path(value="volatile-rest-at-participant/{participantId}")
public class VolatileParticipantResource {
    public static final String BASE_PATH_SEGMENT = "volatile-rest-at-participant";
    private static final Logger LOG = Logger.getLogger(VolatileParticipantResource.class);

    @PUT
    public Response beforeCompletion(@PathParam(value="participantId") String participantId) {
        VolatileParticipant volatileParticipant;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("beforeCompletion request on VolatileParticipantResource. ParticipantId: " + participantId));
        }
        if ((volatileParticipant = ParticipantsContainer.getInstance().getVolatileParticipant(participantId)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Volatile participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        if (this.beforeCompletion(volatileParticipant)) {
            return Response.ok().build();
        }
        return Response.status((int)409).build();
    }

    @PUT
    @Consumes(value={"application/txstatus"})
    public Response afterCompletion(@PathParam(value="participantId") String participantId, String content) {
        VolatileParticipant volatileParticipant;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("afterCompletion request on VolatileParticipantResource. ParticipantId: " + participantId + ", content: " + content));
        }
        if ((volatileParticipant = ParticipantsContainer.getInstance().getVolatileParticipant(participantId)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Volatile participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        if (this.afterCompletion(participantId, volatileParticipant, content)) {
            return Response.ok().build();
        }
        return Response.status((int)409).build();
    }

    private boolean beforeCompletion(VolatileParticipant volatileParticipant) {
        try {
            volatileParticipant.beforeCompletion();
        }
        catch (Throwable t) {
            RESTATLogger.atI18NLogger.warn_beforeVolatileParticipantResource(t.getMessage(), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterCompletion(String participantId, VolatileParticipant volatileParticipant, String content) {
        TxStatus txStatus = TxSupport.toTxStatus((String)content);
        try {
            volatileParticipant.afterCompletion(txStatus);
        }
        catch (Throwable t) {
            RESTATLogger.atI18NLogger.warn_afterVolatileParticipantResource(t.getMessage(), t);
            boolean bl = false;
            return bl;
        }
        finally {
            ParticipantsContainer.getInstance().removeVolatileParticipant(participantId);
        }
        return true;
    }
}

