/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.net.URI;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.JBossLoggerContext;
import org.jboss.logmanager.log4j.JBossStatusListener;

public class JBossLoggerContextFactory
implements LoggerContextFactory {
    private static final Logger.AttachmentKey<Map<Object, LoggerContext>> CONTEXT_KEY = new Logger.AttachmentKey();
    private static final String ROOT_LOGGER_NAME = "";
    private final ReentrantLock lock = new ReentrantLock();

    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
        return this.getLoggerContext(loader, externalContext, currentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
        try {
            LoggerContext loggerContext = this.getLoggerContext(loader, externalContext, currentContext);
            return loggerContext;
        }
        finally {
            if (configLocation != null) {
                StatusLogger.getLogger().warn("Configuration is not allowed for the JBoss Log Manager binding. Ignoring configuration file {}.", (Object)configLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(LoggerContext context) {
        if (context instanceof JBossLoggerContext) {
            LogContext logContext = ((JBossLoggerContext)context).getLogContext();
            this.lock.lock();
            try {
                Map contexts = (Map)logContext.getAttachment(ROOT_LOGGER_NAME, CONTEXT_KEY);
                if (contexts != null) {
                    Iterator iter = contexts.values().iterator();
                    while (iter.hasNext()) {
                        LoggerContext c = (LoggerContext)iter.next();
                        if (!c.equals(context)) continue;
                        iter.remove();
                        break;
                    }
                    if (contexts.isEmpty()) {
                        Logger rootLogger = logContext.getLogger(ROOT_LOGGER_NAME);
                        JBossLoggerContextFactory.detach(rootLogger);
                        JBossStatusListener.remove(logContext);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getLoggerContext(ClassLoader classLoader, Object externalContext, boolean currentContext) {
        if (currentContext || classLoader == null) {
            return this.getOrCreateLoggerContext(LogContext.getLogContext(), externalContext);
        }
        ClassLoader current = JBossLoggerContextFactory.getTccl();
        try {
            JBossLoggerContextFactory.setTccl(classLoader);
            LoggerContext loggerContext = this.getOrCreateLoggerContext(LogContext.getLogContext(), externalContext);
            return loggerContext;
        }
        finally {
            JBossLoggerContextFactory.setTccl(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getOrCreateLoggerContext(LogContext logContext, Object externalContext) {
        Logger rootLogger = logContext.getLogger(ROOT_LOGGER_NAME);
        this.lock.lock();
        try {
            HashMap<Object, LoggerContext> contexts = (HashMap<Object, LoggerContext>)rootLogger.getAttachment(CONTEXT_KEY);
            if (contexts == null) {
                contexts = new HashMap<Object, LoggerContext>();
                JBossLoggerContextFactory.attach(rootLogger, contexts);
            }
            JBossStatusListener.registerIfAbsent(logContext);
            LoggerContext loggerContext = contexts.computeIfAbsent(externalContext, o -> new JBossLoggerContext(logContext, externalContext));
            return loggerContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void attach(Logger logger, Map<Object, LoggerContext> value) {
        if (System.getSecurityManager() == null) {
            logger.attach(CONTEXT_KEY, value);
        } else {
            AccessController.doPrivileged(() -> (Map)logger.attach(CONTEXT_KEY, (Object)value));
        }
    }

    private static void detach(Logger logger) {
        if (System.getSecurityManager() == null) {
            logger.detach(CONTEXT_KEY);
        } else {
            AccessController.doPrivileged(() -> {
                logger.detach(CONTEXT_KEY);
                return null;
            });
        }
    }

    private static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    private static void setTccl(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            });
        }
    }
}

