/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.io.IOException;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricsSubsystemDefinition;
import org.wildfly.extension.metrics.WildFlyMetricRegistry;
import org.wildfly.extension.metrics._private.MetricsLogger;
import org.wildfly.extension.metrics.jmx.JmxMetricCollector;

public class WildFlyMetricRegistryService
implements Service<WildFlyMetricRegistry> {
    private final Consumer<WildFlyMetricRegistry> consumer;
    private WildFlyMetricRegistry registry;

    static void install(OperationContext context) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MetricsSubsystemDefinition.METRICS_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        Consumer registry = serviceBuilder.provides(new ServiceName[]{MetricsSubsystemDefinition.METRICS_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName()});
        serviceBuilder.setInstance((org.jboss.msc.Service)new WildFlyMetricRegistryService(registry)).install();
    }

    WildFlyMetricRegistryService(Consumer<WildFlyMetricRegistry> consumer) {
        this.consumer = consumer;
    }

    public void start(StartContext context) {
        this.registry = new WildFlyMetricRegistry();
        JmxMetricCollector jmxMetricCollector = new JmxMetricCollector(this.registry);
        try {
            jmxMetricCollector.init();
        }
        catch (IOException e) {
            throw MetricsLogger.LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.consumer.accept(this.registry);
    }

    public void stop(StopContext context) {
        this.consumer.accept(null);
        this.registry.close();
        this.registry = null;
    }

    public WildFlyMetricRegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this.registry;
    }
}

