/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.controller.security.ControllerPermission;

public final class InVmAccess {
    private static final ThreadLocal<Boolean> IN_VM_CALL = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private InVmAccess() {
    }

    public static <T> T runInVm(PrivilegedAction<T> action) {
        InVmAccess.checkPermission(ControllerPermission.PERFORM_IN_VM_CALL);
        if (action == null) {
            return null;
        }
        Boolean originalValue = IN_VM_CALL.get();
        try {
            IN_VM_CALL.set(Boolean.TRUE);
            T t = action.run();
            return t;
        }
        finally {
            IN_VM_CALL.set(originalValue);
        }
    }

    public static <T> T runInVm(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        InVmAccess.checkPermission(ControllerPermission.PERFORM_IN_VM_CALL);
        if (action == null) {
            return null;
        }
        Boolean originalValue = IN_VM_CALL.get();
        try {
            IN_VM_CALL.set(Boolean.TRUE);
            T t = action.run();
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            IN_VM_CALL.set(originalValue);
        }
    }

    public static boolean isInVmCall() {
        InVmAccess.checkPermission(ControllerPermission.GET_IN_VM_CALL_STATE);
        return IN_VM_CALL.get();
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

