/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import javax.mail.MailSessionDefinition;
import javax.mail.MailSessionDefinitions;
import org.jboss.as.ee.resource.definition.ResourceDefinitionAnnotationProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.mail.extension.MailSessionDefinitionInjectionSource;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.mail.extension.SessionProviderFactory;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.MailSessionMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.property.PropertyReplacer;

public class MailSessionDefinitionAnnotationProcessor
extends ResourceDefinitionAnnotationProcessor {
    private static final DotName MAIL_SESSION_DEFINITION = DotName.createSimple((String)MailSessionDefinition.class.getName());
    private static final DotName MAIL_SESSION_DEFINITIONS = DotName.createSimple((String)MailSessionDefinitions.class.getName());

    protected DotName getAnnotationDotName() {
        return MAIL_SESSION_DEFINITION;
    }

    protected DotName getAnnotationCollectionDotName() {
        return MAIL_SESSION_DEFINITIONS;
    }

    protected ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        MailSessionMetaData metaData = new MailSessionMetaData();
        metaData.setName(ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"name"));
        metaData.setTransportProtocol(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"transportProtocol"));
        metaData.setStoreProtocol(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"storeProtocol"));
        metaData.setHost(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"host"));
        metaData.setUser(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"user"));
        metaData.setPassword(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"password"));
        metaData.setFrom(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"from"));
        PropertiesMetaData properties = new PropertiesMetaData();
        for (String fullProp : ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalStringArray((AnnotationInstance)annotationInstance, (String)"properties")) {
            PropertyMetaData p = new PropertyMetaData();
            String[] prop = fullProp.split("=", 2);
            p.setName(prop[0]);
            p.setValue(prop[1]);
            properties.add((MappableMetaData)p);
        }
        metaData.setProperties(properties);
        SessionProvider provider = SessionProviderFactory.create(metaData);
        return new MailSessionDefinitionInjectionSource(metaData.getName(), provider);
    }
}

