/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.List;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.jboss.logging.Logger;

public class MirrorTransaction
extends TransactionImpl {
    private static final Logger logger = Logger.getLogger(MirrorTransaction.class);
    MirrorController controlInUse = AMQPMirrorControllerTarget.getControllerInUse();

    public MirrorTransaction(StorageManager storageManager) {
        super(storageManager);
        logger.debug((Object)("controlTarget = " + this.controlInUse + " transactionID = " + this.getID()));
    }

    protected synchronized void afterCommit(List<TransactionOperation> operationsToComplete) {
        MirrorController beforeController = AMQPMirrorControllerTarget.getControllerInUse();
        AMQPMirrorControllerTarget.setControllerInUse(this.controlInUse);
        try {
            super.afterCommit(operationsToComplete);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(beforeController);
        }
    }
}

