/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.pool;

import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class StrictMaxPoolConfigService
implements Service<StrictMaxPoolConfig> {
    private final StrictMaxPoolConfig poolConfig;
    private final InjectedValue<Integer> maxThreadsInjector = new InjectedValue();
    private volatile int declaredMaxSize;
    private volatile Derive derive;

    public StrictMaxPoolConfigService(String poolName, int declaredMaxSize, Derive derive, long timeout, TimeUnit timeUnit) {
        this.declaredMaxSize = declaredMaxSize;
        this.derive = derive;
        this.poolConfig = new StrictMaxPoolConfig(poolName, declaredMaxSize, timeout, timeUnit);
    }

    public void start(StartContext context) throws StartException {
        this.setDerive(this.derive);
    }

    private int calcMaxFromWorkPools() {
        Integer max = (Integer)this.maxThreadsInjector.getOptionalValue();
        return max != null && max > 0 ? max.intValue() : this.calcMaxFromCPUCount();
    }

    private int calcMaxFromCPUCount() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public synchronized void setMaxPoolSize(int newMax) {
        this.declaredMaxSize = newMax;
        if (this.derive == Derive.NONE) {
            this.poolConfig.setMaxPoolSize(newMax);
        }
    }

    public synchronized int getDerivedSize() {
        return this.poolConfig.getMaxPoolSize();
    }

    public synchronized void setDerive(Derive derive) {
        this.derive = derive;
        int max = this.declaredMaxSize;
        switch (derive) {
            case FROM_WORKER_POOLS: {
                max = this.calcMaxFromWorkPools();
                EjbLogger.ROOT_LOGGER.strictPoolDerivedFromWorkers(this.poolConfig.getPoolName(), max);
                break;
            }
            case FROM_CPU_COUNT: {
                max = this.calcMaxFromCPUCount();
                EjbLogger.ROOT_LOGGER.strictPoolDerivedFromCPUs(this.poolConfig.getPoolName(), max);
            }
        }
        this.poolConfig.setMaxPoolSize(max);
    }

    public void setTimeout(long timeout) {
        this.poolConfig.setTimeout(timeout);
    }

    public void setTimeoutUnit(TimeUnit timeUnit) {
        this.poolConfig.setTimeoutUnit(timeUnit);
    }

    public void stop(StopContext context) {
    }

    public StrictMaxPoolConfig getValue() throws IllegalStateException, IllegalArgumentException {
        return this.poolConfig;
    }

    public Injector<Integer> getMaxThreadsInjector() {
        return this.maxThreadsInjector;
    }

    public static enum Derive {
        NONE,
        FROM_WORKER_POOLS,
        FROM_CPU_COUNT;

    }
}

