/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractProtocolConfigurationServiceConfigurator<P extends Protocol, C extends ProtocolConfiguration<P>>
implements ResourceServiceConfigurator,
ProtocolConfiguration<P>,
Consumer<P>,
Supplier<C>,
Dependency {
    private final String name;
    private final Map<String, String> properties = new HashMap<String, String>();
    private volatile Supplier<ModuleLoader> loader;
    private volatile Supplier<ProtocolDefaults> defaults;
    private volatile String moduleName;
    private volatile Boolean statisticsEnabled;

    protected AbstractProtocolConfigurationServiceConfigurator(String name) {
        this.name = name;
    }

    public final ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer configuration = this.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(configuration, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        this.loader = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        this.defaults = builder.requires(ProtocolDefaultsServiceConfigurator.SERVICE_NAME);
        return builder;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.properties.clear();
        for (Property property : AbstractProtocolResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model).asPropertyListOrEmpty()) {
            this.properties.put(property.getName(), property.getValue().asString());
        }
        this.statisticsEnabled = AbstractProtocolResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBooleanOrNull();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final P createProtocol(ProtocolStackConfiguration stackConfiguration) {
        final String protocolName = this.name;
        String moduleName = this.moduleName;
        boolean nativeProtocol = moduleName.equals(AbstractProtocolResourceDefinition.Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !protocolName.startsWith("org.jgroups.protocols.");
        Object className = nativeProtocol ? "org.jgroups.protocols." + protocolName : protocolName;
        try {
            Module module = this.loader.get().loadModule(moduleName);
            final Class<Protocol> protocolClass = module.getClassLoader().loadClass((String)className).asSubclass(Protocol.class);
            final HashMap<String, String> properties = new HashMap<String, String>(this.defaults.get().getProperties(protocolClass));
            properties.putAll(this.properties);
            PrivilegedExceptionAction<Protocol> action = new PrivilegedExceptionAction<Protocol>(){

                @Override
                public Protocol run() throws Exception {
                    try {
                        Protocol protocol = (Protocol)protocolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        HashMap copy = new HashMap(properties);
                        StackType type = Util.getIpStackType();
                        Configurator.resolveAndAssignFields((Object)protocol, copy, (StackType)type);
                        Configurator.resolveAndInvokePropertyMethods((Object)protocol, copy, (StackType)type);
                        List objects = protocol.getConfigurableObjects();
                        if (objects != null) {
                            for (Object object : objects) {
                                Configurator.resolveAndAssignFields(object, copy, (StackType)type);
                                Configurator.resolveAndInvokePropertyMethods(object, copy, (StackType)type);
                            }
                        }
                        if (!copy.isEmpty()) {
                            for (String property : copy.keySet()) {
                                JGroupsLogger.ROOT_LOGGER.unrecognizedProtocolProperty(protocolName, property);
                            }
                        }
                        return protocol;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            Protocol protocol = (Protocol)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action);
            this.accept(protocol);
            protocol.enableStats(this.statisticsEnabled != null ? this.statisticsEnabled.booleanValue() : stackConfiguration.isStatisticsEnabled());
            return (P)protocol;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    void setValue(P protocol, String propertyName, Object propertyValue) {
        PrivilegedAction action = new PrivilegedAction<P>((Protocol)protocol, propertyName, propertyValue){
            final /* synthetic */ Protocol val$protocol;
            final /* synthetic */ String val$propertyName;
            final /* synthetic */ Object val$propertyValue;
            {
                this.val$protocol = protocol;
                this.val$propertyName = string;
                this.val$propertyValue = object;
            }

            @Override
            public P run() {
                return this.val$protocol.setValue(this.val$propertyName, this.val$propertyValue);
            }
        };
        WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }
}

