/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.BinaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ProtocolResourceDefinition
extends AbstractProtocolResourceDefinition {
    static final PathElement WILDCARD_PATH = ProtocolResourceDefinition.pathElement("*");
    static final UnaryOperator<OperationStepHandler> LEGACY_OPERATION_TRANSFORMER = new UnaryOperator<OperationStepHandler>(){

        @Override
        public OperationStepHandler apply(final OperationStepHandler handler) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathElement legacyPath;
                    PathAddress address = context.getCurrentAddress();
                    PathAddress parentAddress = address.getParent();
                    Resource parent = context.readResourceFromRoot(parentAddress, false);
                    if (parent.hasChild(legacyPath = GenericProtocolResourceDefinition.pathElement(address.getLastElement().getValue()))) {
                        PathAddress legacyAddress = parentAddress.append(new PathElement[]{legacyPath});
                        operation.get("address").set(legacyAddress.toModelNode());
                        String operationName = operation.get("operation").asString();
                        context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(legacyAddress, operationName), OperationContext.Stage.MODEL);
                    } else {
                        handler.execute(context, operation);
                    }
                }
            };
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"protocol", (String)name);
    }

    ProtocolResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfiguratorFactory serviceConfiguratorFactory, ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        super(new SimpleResourceDefinition.Parameters(path, path.isWildcard() ? JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path}) : JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, WILDCARD_PATH})).setOrderedChild(), new ResourceDescriptorConfigurator(configurator), serviceConfiguratorFactory, parentServiceConfiguratorFactory);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addCapabilities(Capability.class);
        }
    }

    static class LegacyAddOperationTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final Predicate<ModelNode> legacy;

        <E extends Enum<E>> LegacyAddOperationTransformation(Class<E> attributeClass) {
            this.legacy = operation -> {
                for (Attribute attribute : EnumSet.allOf(attributeClass)) {
                    if (!operation.hasDefined(attribute.getName())) continue;
                    return false;
                }
                return true;
            };
        }

        LegacyAddOperationTransformation(String ... legacyProperties) {
            this.legacy = operation -> {
                if (!operation.hasDefined(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName())) {
                    return false;
                }
                for (String legacyProperty : legacyProperties) {
                    if (!operation.get(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName()).hasDefined(legacyProperty)) continue;
                    return true;
                }
                return false;
            };
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (this.legacy.test(operation)) {
                    PathElement path = context.getCurrentAddress().getLastElement();
                    OperationStepHandler genericHandler = context.getResourceRegistration().getParent().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{WILDCARD_PATH}), "add");
                    operation.get("address").set(context.getCurrentAddress().getParent().append(new PathElement[]{GenericProtocolResourceDefinition.pathElement(path.getValue())}).toModelNode());
                    context.addStep(operation, genericHandler, OperationContext.Stage.MODEL, true);
                } else {
                    handler.execute(context, operation);
                }
            };
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        PROTOCOL("org.wildfly.clustering.jgroups.protocol");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.PARENT_CHILD).setAllowMultipleRegistrations(true).build();
        }

        public RuntimeCapability<?> getDefinition() {
            return this.definition;
        }
    }
}

