/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.reflect.ProxyMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.extension.clustering.web.JBossMarshallingVersion;

public enum SessionMarshallerFactory implements Function<DeploymentUnit, ByteBufferMarshaller>
{
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(DeploymentUnit unit) {
            Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            return new JBossByteBufferMarshaller((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(JBossMarshallingVersion.class, (Enum)JBossMarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public ByteBufferMarshaller apply(DeploymentUnit unit) {
            Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            SerializationContextBuilder builder = new SerializationContextBuilder((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(module.getModuleLoader())).load((ClassLoader)module.getClassLoader());
            EEModuleConfiguration configuration = (EEModuleConfiguration)unit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
            IdentityHashMap<Class, LinkedList<ViewConfiguration>> components = new IdentityHashMap<Class, LinkedList<ViewConfiguration>>();
            for (ComponentConfiguration componentConfiguration : configuration.getComponentConfigurations()) {
                for (ViewConfiguration view : componentConfiguration.getViews()) {
                    Class proxyClass = view.getProxyFactory().defineClass();
                    if (!WriteReplaceInterface.class.isAssignableFrom(proxyClass)) continue;
                    LinkedList<ViewConfiguration> views = (LinkedList<ViewConfiguration>)components.get(view.getViewClass());
                    if (views == null) {
                        views = new LinkedList<ViewConfiguration>();
                        components.put(view.getViewClass(), views);
                    }
                    views.add(view);
                }
            }
            if (!components.isEmpty()) {
                for (final Map.Entry entry : components.entrySet()) {
                    final String viewClassName = ((Class)entry.getKey()).getName();
                    StringBuilder schemaBuilder = new StringBuilder();
                    schemaBuilder.append("package ").append(viewClassName).append(';').append(System.lineSeparator());
                    for (ViewConfiguration view : (List)entry.getValue()) {
                        schemaBuilder.append("message ").append(view.getComponentConfiguration().getComponentName()).append(" { optional bytes proxy = 1; }").append(System.lineSeparator());
                    }
                    final String schema = schemaBuilder.toString();
                    builder.register(new SerializationContextInitializer(){

                        @Deprecated
                        public String getProtoFileName() {
                            return null;
                        }

                        @Deprecated
                        public String getProtoFile() {
                            return null;
                        }

                        public void registerSchema(SerializationContext context) {
                            context.registerProtoFiles(FileDescriptorSource.fromString((String)(viewClassName + ".proto"), (String)schema));
                        }

                        public void registerMarshallers(SerializationContext context) {
                            for (final ViewConfiguration view : (List)entry.getValue()) {
                                context.registerMarshaller((BaseMarshaller)new ProxyMarshaller<Object>(view.getProxyFactory().defineClass()){

                                    public String getTypeName() {
                                        return viewClassName + "." + view.getComponentConfiguration().getComponentName();
                                    }
                                });
                            }
                        }
                    });
                }
            }
            return new ProtoStreamByteBufferMarshaller(builder.build());
        }
    };

}

