/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import javax.security.auth.Subject;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.ElytronMessages;
import org.wildfly.security.authz.jacc.RoleToGroupMapper;
import org.wildfly.security.authz.jacc.SecurityActions;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;

final class SubjectUtil {
    private static final boolean CONVERT_ROLES_TO_GROUP;

    SubjectUtil() {
    }

    static Subject fromSecurityIdentity(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        Subject subject = new Subject();
        subject.getPrincipals().add(securityIdentity.getPrincipal());
        if (CONVERT_ROLES_TO_GROUP) {
            subject.getPrincipals().addAll(RoleToGroupMapper.convert(securityIdentity.getPrincipal(), securityIdentity.getRoles()));
        }
        for (Credential credential : securityIdentity.getPublicCredentials()) {
            if (credential instanceof PublicKeyCredential) {
                subject.getPublicCredentials().add(((PublicKeyCredential)credential.castAs(PublicKeyCredential.class)).getPublicKey());
                continue;
            }
            if (credential instanceof X509CertificateChainPublicCredential) {
                subject.getPublicCredentials().add(((X509CertificateChainPublicCredential)credential.castAs(X509CertificateChainPublicCredential.class)).getCertificateChain());
                continue;
            }
            subject.getPublicCredentials().add(credential);
        }
        for (Credential credential : SecurityActions.doPrivileged(() -> ((SecurityIdentity)securityIdentity).getPrivateCredentials())) {
            if (credential instanceof PasswordCredential) {
                SubjectUtil.addPrivateCredential(subject, ((PasswordCredential)credential.castAs(PasswordCredential.class)).getPassword());
                continue;
            }
            if (credential instanceof SecretKeyCredential) {
                SubjectUtil.addPrivateCredential(subject, ((SecretKeyCredential)credential.castAs(SecretKeyCredential.class)).getSecretKey());
                continue;
            }
            if (credential instanceof KeyPairCredential) {
                SubjectUtil.addPrivateCredential(subject, ((KeyPairCredential)credential.castAs(KeyPairCredential.class)).getKeyPair());
                continue;
            }
            if (credential instanceof X509CertificateChainPrivateCredential) {
                SubjectUtil.addPrivateCredential(subject, ((X509CertificateChainPrivateCredential)credential.castAs(X509CertificateChainPrivateCredential.class)).getCertificateChain());
                continue;
            }
            SubjectUtil.addPrivateCredential(subject, credential);
        }
        SubjectUtil.addPrivateCredential(subject, securityIdentity);
        return subject;
    }

    static void addPrivateCredential(Subject subject, Object credential) {
        SecurityActions.doPrivileged(() -> {
            subject.getPrivateCredentials().add(credential);
            return null;
        });
    }

    static {
        boolean convertRolesToGroup = false;
        try {
            Class.forName("java.security.acl.Group");
            convertRolesToGroup = true;
        }
        catch (ClassNotFoundException e) {
            ElytronMessages.log.trace("Class 'java.security.acl.Group' is not available, role to group mapping disabled.");
        }
        CONVERT_ROLES_TO_GROUP = convertRolesToGroup;
    }
}

