/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import java.net.URI;
import java.util.Map;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private final SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch> manager;

    public DistributableSingleSignOnManager(SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch> manager) {
        this.manager = manager;
    }

    public SingleSignOn create(String mechanismName, boolean programmatic, SecurityIdentity identity) {
        String id = (String)this.manager.getIdentifierFactory().get();
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            SSO sso = this.manager.createSSO(id, (Object)new ElytronAuthentication(mechanismName, programmatic, identity.getPrincipal().getName()));
            ((LocalSSOContext)sso.getLocalContext()).setSecurityIdentity(identity);
            return new DistributableSingleSignOn((SSO<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext>)sso, (Batcher<Batch>)batcher, batcher.suspendBatch());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public SingleSignOn find(String id) {
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        boolean close = true;
        try {
            SSO sso = this.manager.findSSO(id);
            if (sso == null) {
                SingleSignOn singleSignOn = null;
                return singleSignOn;
            }
            close = false;
            DistributableSingleSignOn distributableSingleSignOn = new DistributableSingleSignOn((SSO<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext>)sso, (Batcher<Batch>)batcher, batcher.suspendBatch());
            return distributableSingleSignOn;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }
}

