/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.weld.WeldProvider;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.ModuleGroupSingletonProvider;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldBootstrapService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldBootstrapService"});
    public static final ServiceName INTERNAL_SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldBootstrapServiceInternal"});
    private final WeldBootstrap bootstrap;
    private final WeldDeployment deployment;
    private final Environment environment;
    private final Map<String, BeanDeploymentArchive> beanDeploymentArchives;
    private final BeanDeploymentArchiveImpl rootBeanDeploymentArchive;
    private final String deploymentName;
    private final Consumer<WeldBootstrapService> weldBootstrapServiceConsumer;
    private final Supplier<ExecutorServices> executorServicesSupplier;
    private final Supplier<ExecutorService> serverExecutorSupplier;
    private final Supplier<SecurityServices> securityServicesSupplier;
    private final Supplier<TransactionServices> weldTransactionServicesSupplier;
    private final ServiceName deploymentServiceName;
    private final ServiceName weldBootstrapServiceName;
    private volatile boolean started;
    private volatile ServiceController<?> controller;
    private final AtomicBoolean runOnce = new AtomicBoolean();

    public WeldBootstrapService(WeldDeployment deployment, Environment environment, String deploymentName, Consumer<WeldBootstrapService> weldBootstrapServiceConsumer, Supplier<ExecutorServices> executorServicesSupplier, Supplier<ExecutorService> serverExecutorSupplier, Supplier<SecurityServices> securityServicesSupplier, Supplier<TransactionServices> weldTransactionServicesSupplier, ServiceName deploymentServiceName, ServiceName weldBootstrapServiceName) {
        this.deployment = deployment;
        this.environment = environment;
        this.deploymentName = deploymentName;
        this.weldBootstrapServiceConsumer = weldBootstrapServiceConsumer;
        this.executorServicesSupplier = executorServicesSupplier;
        this.serverExecutorSupplier = serverExecutorSupplier;
        this.securityServicesSupplier = securityServicesSupplier;
        this.weldTransactionServicesSupplier = weldTransactionServicesSupplier;
        this.deploymentServiceName = deploymentServiceName;
        this.weldBootstrapServiceName = weldBootstrapServiceName;
        this.bootstrap = new WeldBootstrap();
        HashMap<String, BeanDeploymentArchive> bdas = new HashMap<String, BeanDeploymentArchive>();
        BeanDeploymentArchiveImpl rootBeanDeploymentArchive = null;
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            BeanDeploymentArchiveImpl bda;
            bdas.put(archive.getId(), archive);
            if (!(archive instanceof BeanDeploymentArchiveImpl) || !(bda = (BeanDeploymentArchiveImpl)archive).isRoot()) continue;
            rootBeanDeploymentArchive = bda;
        }
        this.rootBeanDeploymentArchive = rootBeanDeploymentArchive;
        this.beanDeploymentArchives = Collections.unmodifiableMap(bdas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) {
        TransactionServices transactionServices;
        if (!this.runOnce.compareAndSet(false, true)) {
            ServiceController controller = context.getController().getServiceContainer().getService(this.deploymentServiceName);
            controller.addListener(new LifecycleListener(){

                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    if (event == LifecycleEvent.DOWN) {
                        controller.setMode(ServiceController.Mode.ACTIVE);
                        controller.removeListener((LifecycleListener)this);
                    }
                }
            });
            controller.setMode(ServiceController.Mode.NEVER);
            return;
        }
        if (this.started) {
            throw WeldLogger.ROOT_LOGGER.alreadyRunning("WeldContainer");
        }
        this.started = true;
        WeldLogger.DEPLOYMENT_LOGGER.startingWeldService(this.deploymentName);
        this.addWeldService(SecurityServices.class, this.securityServicesSupplier.get());
        TransactionServices transactionServices2 = transactionServices = this.weldTransactionServicesSupplier != null ? this.weldTransactionServicesSupplier.get() : null;
        if (transactionServices != null) {
            this.addWeldService(TransactionServices.class, transactionServices);
        }
        if (!this.deployment.getServices().contains(ExecutorServices.class)) {
            this.addWeldService(ExecutorServices.class, this.executorServicesSupplier.get());
        }
        ModuleGroupSingletonProvider.addClassLoaders((ClassLoader)this.deployment.getModule().getClassLoader(), this.deployment.getSubDeploymentClassLoaders());
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.deployment.getModule().getClassLoader());
            this.bootstrap.startContainer(this.deploymentName, this.environment, (Deployment)this.deployment);
            WeldProvider.containerInitialized(Container.instance((String)this.deploymentName), this.getBeanManager(), this.deployment);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
        this.weldBootstrapServiceConsumer.accept(this);
        ServiceBuilder weldBootstrapServiceBuilder = context.getChildTarget().addService(this.weldBootstrapServiceName);
        final Consumer provider = weldBootstrapServiceBuilder.provides(new ServiceName[]{this.weldBootstrapServiceName});
        weldBootstrapServiceBuilder.setInstance(new Service(){

            public void start(StartContext context) throws StartException {
                provider.accept(WeldBootstrapService.this);
            }

            public void stop(StopContext context) {
                context.getController().setMode(ServiceController.Mode.REMOVE);
            }
        });
        weldBootstrapServiceBuilder.install();
        this.controller = context.getController();
    }

    public synchronized void stop(final StopContext context) {
        Container container;
        this.weldBootstrapServiceConsumer.accept(null);
        if (this.started && (container = Container.instance((String)this.deploymentName)) != null && !ContainerState.SHUTDOWN.equals((Object)container.getState())) {
            context.asynchronous();
            ExecutorService executorService = this.serverExecutorSupplier.get();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Weld container cleanup for deployment %s", (Object)WeldBootstrapService.this.deploymentName);
                    ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                    try {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)WeldBootstrapService.this.deployment.getModule().getClassLoader());
                        WeldProvider.containerShutDown(container);
                        container.setState(ContainerState.SHUTDOWN);
                        container.cleanup();
                        WeldBootstrapService.this.startServiceShutdown();
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                        ModuleGroupSingletonProvider.removeClassLoader((ClassLoader)WeldBootstrapService.this.deployment.getModule().getClassLoader());
                        context.complete();
                    }
                }
            };
            try {
                executorService.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    public BeanManagerImpl getBeanManager(String beanArchiveId) {
        if (!this.started) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        BeanDeploymentArchive beanDeploymentArchive = this.beanDeploymentArchives.get(beanArchiveId);
        if (beanDeploymentArchive == null) {
            throw WeldLogger.ROOT_LOGGER.beanDeploymentNotFound(beanArchiveId);
        }
        return this.bootstrap.getManager(beanDeploymentArchive);
    }

    public <T extends org.jboss.weld.bootstrap.api.Service> void addWeldService(Class<T> type, T service) {
        this.deployment.addWeldService(type, service);
    }

    public BeanManagerImpl getBeanManager() {
        if (!this.started) {
            throw WeldLogger.ROOT_LOGGER.notStarted("WeldContainer");
        }
        return this.bootstrap.getManager((BeanDeploymentArchive)this.rootBeanDeploymentArchive);
    }

    public Set<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return new HashSet<BeanDeploymentArchive>(this.beanDeploymentArchives.values());
    }

    public boolean isStarted() {
        return this.started;
    }

    void startServiceShutdown() {
        this.started = false;
        if (this.controller.getServiceContainer().isShutdown()) {
            return;
        }
        final ServiceController deploymentController = this.controller.getServiceContainer().getService(this.deploymentServiceName);
        if (deploymentController.getMode() != ServiceController.Mode.ACTIVE) {
            return;
        }
        final CompletableFuture<Boolean> attemptingBounce = new CompletableFuture<Boolean>();
        try {
            final CompletableFuture<Boolean> listenerDone = new CompletableFuture<Boolean>();
            LifecycleListener listener = new LifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    block9: {
                        try {
                            if (controller.getServiceContainer().isShutdown() || !((Boolean)attemptingBounce.get()).booleanValue()) {
                                controller.removeListener((LifecycleListener)this);
                                return;
                            }
                            if (deploymentController.getMode() != ServiceController.Mode.ACTIVE) return;
                            if (controller.getMode() != ServiceController.Mode.REMOVE) break block9;
                            return;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (event != LifecycleEvent.DOWN) return;
                    controller.removeListener((LifecycleListener)this);
                    do {
                        if (controller.getMode() == ServiceController.Mode.NEVER) continue;
                        return;
                    } while (!controller.compareAndSetMode(ServiceController.Mode.NEVER, ServiceController.Mode.ACTIVE));
                    return;
                    finally {
                        listenerDone.complete(true);
                    }
                }
            };
            this.controller.getServiceContainer().addService(this.controller.getName().append(new String[]{"fakeStabilityService"})).setInstance(new Service(){

                public void start(final StartContext context) throws StartException {
                    context.asynchronous();
                    listenerDone.handle(new BiFunction<Boolean, Throwable, Object>(){

                        @Override
                        public Object apply(Boolean aBoolean, Throwable throwable) {
                            context.getController().setMode(ServiceController.Mode.REMOVE);
                            context.complete();
                            return null;
                        }
                    });
                }

                public void stop(StopContext context) {
                }
            }).install();
            this.controller.addListener(listener);
            if (!this.controller.compareAndSetMode(ServiceController.Mode.ACTIVE, ServiceController.Mode.NEVER)) {
                this.controller.removeListener(listener);
                attemptingBounce.complete(false);
                listenerDone.complete(false);
            } else {
                attemptingBounce.complete(true);
            }
        }
        catch (Throwable t) {
            attemptingBounce.completeExceptionally(t);
            throw new RuntimeException(t);
        }
    }

    WeldDeployment getDeployment() {
        return this.deployment;
    }

    String getDeploymentName() {
        return this.deploymentName;
    }

    WeldBootstrap getBootstrap() {
        return this.bootstrap;
    }
}

