/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.sql.DataSource;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.job.repository.JobRepositoryService;

public class JdbcJobRepositoryService
extends JobRepositoryService
implements Service<JobRepository> {
    private final InjectedValue<DataSource> dataSourceValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private volatile JdbcRepository jobRepository;

    public JdbcJobRepositoryService(Integer executionRecordsLimit) {
        super(executionRecordsLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startJobRepository(StartContext context) throws StartException {
        ExecutorService service = (ExecutorService)this.executor.getValue();
        Runnable task = () -> {
            try {
                this.jobRepository = new JdbcRepository((DataSource)this.dataSourceValue.getValue());
                context.complete();
            }
            catch (Exception e) {
                context.failed(BatchLogger.LOGGER.failedToCreateJobRepository(e, "JDBC"));
            }
        };
        try {
            service.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    @Override
    public void stopJobRepository(StopContext context) {
        this.jobRepository = null;
    }

    @Override
    protected JobRepository getDelegate() {
        return this.jobRepository;
    }

    public InjectedValue<DataSource> getDataSourceInjector() {
        return this.dataSourceValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executor;
    }
}

