/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionTargets {
    private InjectionTargets() {
    }

    public static <T> NonProducibleInjectionTarget<T> createNonProducibleInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        return InjectionTargets.createNonProducibleInjectionTarget(type, bean, null, null, beanManager);
    }

    public static <T> NonProducibleInjectionTarget<T> createNonProducibleInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, Injector<T> injector, LifecycleCallbackInvoker<T> invoker, BeanManagerImpl beanManager) {
        try {
            if (type.isAbstract()) {
                if (type.getJavaClass().isInterface()) {
                    throw BeanLogger.LOG.injectionTargetCannotBeCreatedForInterface(type);
                }
                BeanLogger.LOG.injectionTargetCreatedForAbstractClass(type.getJavaClass());
                return NonProducibleInjectionTarget.create(type, bean, injector, invoker, beanManager);
            }
            if (!Reflections.isTopLevelOrStaticNestedClass(type.getJavaClass())) {
                BeanLogger.LOG.injectionTargetCreatedForNonStaticInnerClass(type.getJavaClass());
                return NonProducibleInjectionTarget.create(type, bean, injector, invoker, beanManager);
            }
            if (Beans.getBeanConstructor(type) == null) {
                if (bean != null) {
                    throw BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructorException(type.getJavaClass());
                }
                BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructor(type.getJavaClass());
                return NonProducibleInjectionTarget.create(type, null, injector, invoker, beanManager);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
        return null;
    }
}

