/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionHandle;
import org.wildfly.httpclient.transaction.HttpSubordinateTransactionHandle;
import org.wildfly.httpclient.transaction.TransactionConstants;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;
import org.xnio.IoUtils;

public class HttpRemoteTransactionPeer
implements RemoteTransactionPeer {
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final HttpTargetContext targetContext;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final AuthenticationContext authenticationContext;

    public HttpRemoteTransactionPeer(HttpTargetContext targetContext, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        this.targetContext = targetContext;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
        this.authenticationContext = AuthenticationContext.captureCurrent();
    }

    @Override
    public SubordinateTransactionControl lookupXid(Xid xid) throws XAException {
        try {
            return new HttpSubordinateTransactionHandle(xid, this.targetContext, this.getSslContext(this.targetContext.getUri()), this.authenticationConfiguration);
        }
        catch (GeneralSecurityException e) {
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
    }

    @Override
    public Xid[] recover(int flag, String parentName) throws XAException {
        SSLContext sslContext;
        CompletableFuture xidList = new CompletableFuture();
        ClientRequest cr = new ClientRequest().setPath(this.targetContext.getUri().getPath() + "/txn/v1/xa/recover" + "/" + parentName).setMethod(Methods.GET);
        cr.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-txn-jbmar-xid-list;version=1,application/x-wf-jbmar-new-txn;version=1");
        cr.getRequestHeaders().put(TransactionConstants.RECOVERY_PARENT_NAME, parentName);
        cr.getRequestHeaders().put(TransactionConstants.RECOVERY_FLAGS, Integer.toString(flag));
        AuthenticationConfiguration authenticationConfiguration = this.getAuthenticationConfiguration(this.targetContext.getUri());
        try {
            sslContext = this.getSslContext(this.targetContext.getUri());
        }
        catch (GeneralSecurityException e) {
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        this.targetContext.sendRequest(cr, sslContext, authenticationConfiguration, null, (result, response, closeable) -> {
            try {
                Unmarshaller unmarshaller = this.targetContext.createUnmarshaller(HttpRemoteTransactionPeer.createMarshallingConf());
                unmarshaller.start(new InputStreamByteInput(result));
                int length = unmarshaller.readInt();
                Xid[] ret = new Xid[length];
                for (int i = 0; i < length; ++i) {
                    int formatId = unmarshaller.readInt();
                    int len = unmarshaller.readInt();
                    byte[] globalId = new byte[len];
                    unmarshaller.readFully(globalId);
                    len = unmarshaller.readInt();
                    byte[] branchId = new byte[len];
                    unmarshaller.readFully(branchId);
                    ret[i] = new SimpleXid(formatId, globalId, branchId);
                }
                xidList.complete(ret);
                unmarshaller.finish();
            }
            catch (Exception e) {
                xidList.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose(closeable);
            }
        }, xidList::completeExceptionally, TransactionConstants.NEW_TRANSACTION, null);
        try {
            return (Xid[])xidList.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XAException) {
                throw (XAException)cause;
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(cause);
            throw xaException;
        }
    }

    @Override
    public SimpleTransactionControl begin(int timeout) throws SystemException {
        SSLContext sslContext;
        CompletableFuture beginXid = new CompletableFuture();
        ClientRequest cr = new ClientRequest().setPath(this.targetContext.getUri().getPath() + "/txn/v1/ut/begin").setMethod(Methods.POST);
        cr.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jbmar-exception;version=1,application/x-wf-jbmar-new-txn;version=1");
        cr.getRequestHeaders().put(TransactionConstants.TIMEOUT, timeout);
        AuthenticationConfiguration authenticationConfiguration = this.getAuthenticationConfiguration(this.targetContext.getUri());
        try {
            sslContext = this.getSslContext(this.targetContext.getUri());
        }
        catch (GeneralSecurityException e) {
            throw new SystemException(e.getMessage());
        }
        this.targetContext.sendRequest(cr, sslContext, authenticationConfiguration, null, (result, response, closeable) -> {
            try {
                Unmarshaller unmarshaller = this.targetContext.createUnmarshaller(HttpRemoteTransactionPeer.createMarshallingConf());
                unmarshaller.start(new InputStreamByteInput(result));
                int formatId = unmarshaller.readInt();
                int len = unmarshaller.readInt();
                byte[] globalId = new byte[len];
                unmarshaller.readFully(globalId);
                len = unmarshaller.readInt();
                byte[] branchId = new byte[len];
                unmarshaller.readFully(branchId);
                SimpleXid simpleXid = new SimpleXid(formatId, globalId, branchId);
                beginXid.complete(simpleXid);
                unmarshaller.finish();
            }
            catch (Exception e) {
                beginXid.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose(closeable);
            }
        }, beginXid::completeExceptionally, TransactionConstants.NEW_TRANSACTION, null);
        try {
            Xid xid = (Xid)beginXid.get();
            return new HttpRemoteTransactionHandle(xid, this.targetContext, sslContext, authenticationConfiguration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            SystemException ex = new SystemException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private AuthenticationConfiguration getAuthenticationConfiguration(URI location) {
        if (this.authenticationConfiguration == null) {
            return CLIENT.getAuthenticationConfiguration(location, this.authenticationContext, -1, "jta", "jboss");
        }
        return this.authenticationConfiguration;
    }

    private SSLContext getSslContext(URI location) throws GeneralSecurityException {
        if (this.sslContext == null) {
            return CLIENT.getSSLContext(location, this.authenticationContext, "jta", "jboss");
        }
        return this.sslContext;
    }

    static MarshallingConfiguration createMarshallingConf() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }
}

