/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RetryContext {
    static int MAX_RECORDED_FAILURES = 10;
    private URI destination;
    private Set<URI> transientFailed = Collections.emptySet();
    private List<Throwable> failures = Collections.emptyList();
    private boolean explicitFailure = false;

    public void setCurrentDestination(URI destination) {
        this.destination = destination;
    }

    public URI currentDestination() {
        return this.destination;
    }

    public boolean hasTransientlyFailed(URI destination) {
        return this.transientFailed.contains(destination);
    }

    public void addTransientFail(URI destination) {
        if (this.transientFailed.size() == 0) {
            this.transientFailed = new HashSet<URI>(1);
        }
        this.transientFailed.add(destination);
    }

    public int transientFailCount() {
        return this.transientFailed.size();
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public void addExplicitFailure(Throwable failure) {
        this.explicitFailure = true;
        this.failures = Collections.singletonList(failure);
    }

    public boolean hasExplicitFailure() {
        return this.explicitFailure;
    }

    public void addFailure(Throwable failure) {
        if (this.explicitFailure || this.failures.size() >= MAX_RECORDED_FAILURES) {
            return;
        }
        if (this.failures.size() == 0) {
            this.failures = new ArrayList<Throwable>(1);
        }
        this.failures.add(failure);
    }
}

